﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FormGenerator.Repository.Forms;
using System.Windows.Forms;
using System.IO;
using System.Text.RegularExpressions;
using FormGenerator.Repository;

namespace FormGenerator.Generate
{
    public class CardGenerator:Generator
    {
        
        private const string TemplatePath = "";

        private const int FIRST_FIELD_Y_POSITION = 50;
        private const int Y_FIELDS_STEP = 40;
        private const int X_LABEL_POSITION = 10;
        private const int X_FIELD_POSITION = 100;
        private const int LABEL_SIZE_X = 100;
        private const int LABEL_SIZE_Y = 10;
        private const int FIELD_SIZE_X = 230;
        private const int FIELD_SIZE_Y = 20;
        private const int FIELD_SIZE_AUX_LIST = 210;
        private const int FIELD__MULTILINE_SIZE_Y = 70;

        private const int FORM_BOTTOM_HEIGHT = 100;

        private Card card;
       
        public CardGenerator(Card card )
        {
            this.card = card;
          
        }


        public void Generate(string path)
        {
            //move to copy

            string fromPath = Application.StartupPath+"\\Templates\\Card.cs";
            string toPath = path + "\\" + card.Name+".cs";
            Directory.CreateDirectory(path);
            File.Copy(fromPath, toPath,true);

            //move to generate

            ReplaceInFile(toPath, "ZZfnZZ", card.Name);
            ReplaceInFile(toPath, "ZZlnZZ", card.LogicName);
            ReplaceInFile(toPath, "ZZpnZZ", DatabaseGenerator.getSqlTableName(card.Class.Name));



            String fieldsPrivateDeclaration = "";
            String fieldsAddDeclaration = "";
            String fieldsNewDesigner = "";
            String tabsAddDesigner = "";
            String fieldsDesign = "";
            int currentYPosition;
            int tabCounter = 0;
            int maxTabHeight = 0;
            foreach (CardTab tab in card.Tabs)
            {
                currentYPosition = FIRST_FIELD_Y_POSITION;
                foreach (CardField f in tab.Fields)
                {
                    fieldsPrivateDeclaration += GetLabelFieldPrivateDeclaration(f);
                    fieldsPrivateDeclaration += GetFieldPrivateDeclaration(f);
                    fieldsAddDeclaration += GetFieldsAddDeclaration(f);
                    fieldsNewDesigner += GetFieldsLabelNewDesigner(f);
                    fieldsNewDesigner += GetFieldsNewDesigner(f);
                    fieldsDesign += GetFieldsLabelDesign(f, X_LABEL_POSITION, currentYPosition, LABEL_SIZE_X, LABEL_SIZE_Y, tabCounter);
                    fieldsDesign += GetFieldsDesign(f, X_FIELD_POSITION, currentYPosition, FIELD_SIZE_X, GetFieldHeight(f), tabCounter);
                    currentYPosition += Y_FIELDS_STEP + GetFieldHeight(f) - FIELD_SIZE_Y; ;
                }

                if (tabCounter > 0)
                {
                    fieldsPrivateDeclaration += "private System.Windows.Forms.TabPage " + GetFieldName(tab, tabCounter) + ";\n";
                    fieldsNewDesigner += "this." + GetFieldName(tab, tabCounter) + " = new System.Windows.Forms.TabPage();\n";
                    tabsAddDesigner += "this.tabControl.Controls.Add(this." + GetFieldName(tab, tabCounter) + ");\n";
                    tabsAddDesigner += "this.tabControl.Controls.SetChildIndex(this." + GetFieldName(tab, tabCounter) + ", 0);\n";
                }
              
               fieldsDesign += GetTabDesign(tab, tabCounter);
                tabCounter++;
                maxTabHeight = Math.Max(maxTabHeight, currentYPosition);
            }
            ReplaceInFile(toPath, "ZZFieldsPrivateZZ", fieldsPrivateDeclaration);
            ReplaceInFile(toPath, "ZZFieldsAddZZ", fieldsAddDeclaration);
            ReplaceInFile(toPath, "ZZFieldsNewZZ", fieldsNewDesigner);
            ReplaceInFile(toPath, "ZZTabsAddZZ", tabsAddDesigner);
            ReplaceInFile(toPath, "ZZTabsBodyZZ", fieldsDesign);
            ReplaceInFile(toPath, "ZZFormHeightZZ", (maxTabHeight + FORM_BOTTOM_HEIGHT).ToString());

            // disabling of fields
        }

        private static String GetFieldPrivateDeclaration(CardField field)
        {
            if (field is CardFieldSimple)
            {
                switch (((CardFieldSimple)field).Field.Type)
                {
                    case Field.STRING:
                        string controlName = "TextEdit";
                        if ((((CardFieldSimple)field).Additional!=null)&&(((CardFieldSimple)field).Additional.Equals(CardFieldSimple.MULTILINE)))
                        {
                            controlName = "MemoEdit";
                        }
                        return ("		private "+controlName+" textEdit" + field.Name + ";" + "\n");

                    case Field.INT:
                    case Field.DECIMAL:
                        return ("		private TextEdit textEdit" + field.Name + ";" + "\n");
                    case Field.DATE:
                        return ("		private Tercom.RealIT.CommonGUI.DateEditor dateEditor" + field.Name + ";" + "\n");
                    case Field.BOOL:
                        return ("		private CheckEdit chkEdit" + field.Name + ";" + "\n");



                }
                return "";
            }
            if (field is CardFieldRelation)
            {
                return ("		private DevExpress.XtraEditors.LookUpEdit lookUpEdit" + ((CardFieldRelation)field).RelatedClass.Name + ";" + "\n");
            }
            if (field is CardFieldAuxList)
            {
                if (((CardFieldAuxList)field).List != null)
                {
                    return ("		private " + ((CardFieldAuxList)field).List.Name + " control" + ((CardFieldAuxList)field).List.Name + ";" + "\n");
                }
            }
            return "";
        }

        private String GetFieldsAddDeclaration(CardField field)
        {
            if (field is CardFieldSimple)
            {
                switch (((CardFieldSimple)field).Field.Type)
                {
                    
                    case Field.STRING:
                    case Field.INT:
                    case Field.DECIMAL:
                        return ("		    AddBaseEditField(\"" + DatabaseGenerator.getSqlFieldName(((CardFieldSimple)field).Field.Name) + "\",textEdit" + ((CardFieldSimple)field).Field.Name + ");" + "\n");
                    case Field.DATE:
                        return ("		    AddBaseEditField(\"" + DatabaseGenerator.getSqlFieldName(((CardFieldSimple)field).Field.Name) + "\",dateEditor" + ((CardFieldSimple)field).Field.Name + ");" + "\n");
                    case Field.BOOL:
                        return ("		    AddBaseEditField(\"" + DatabaseGenerator.getSqlFieldName(((CardFieldSimple)field).Field.Name) + "\",chkEdit" + ((CardFieldSimple)field).Field.Name + ");" + "\n");
                }
                return "";
            }
            if (field is CardFieldRelation)
            {
                CardFieldRelation cfr = (CardFieldRelation)field;

                string displayedFieldName = "Id";
                if (cfr.Field!=null)
                {
                    displayedFieldName = DatabaseGenerator.getSqlFieldName( cfr.Field.Name);
                }

                return ("		AddField(new LookupCardField(\"" + DatabaseGenerator.getSqlTableName(cfr.Name) + "Id\",\"" + "blablabla\", lookUpEdit" + cfr.Name + ", \"Id\",\"" + displayedFieldName + "\", true,\"" + DatabaseGenerator.getSqlTableName(cfr.Name) + "\",\"" + displayedFieldName + "\"));");
            }
            if (field is CardFieldAuxList)
            {
                CardFieldAuxList cfal = (CardFieldAuxList)field;
                if (cfal.List!=null){
               return ("	 control"+cfal.List.Name+".LinkedColumn = \""+DatabaseGenerator.getSqlTableName( card.Class.Name)+"Id\";	");
                }
            }
            
            return "";
        }

        private static String GetLabelFieldPrivateDeclaration(CardField field)
        {
            return ("		private Label label" + field.Name + ";" + "\n");
        }

        private static String GetFieldsNewDesigner(CardField field)
        {
            if (field is CardFieldSimple)
            {
                switch (((CardFieldSimple)field).Field.Type)
                {
                    case Field.STRING:
                        {
                            string controlName = "TextEdit";
                            if ((((CardFieldSimple)field).Additional != null) && (((CardFieldSimple)field).Additional.Equals(CardFieldSimple.MULTILINE)))
                            {
                                controlName = "MemoEdit";
                                 }
                            return ("          this.textEdit" + field.Name + " = new DevExpress.XtraEditors." + controlName + "();\n");
                           
                        }
                    case Field.INT:
                    case Field.DECIMAL:
                        return ("          this.textEdit" + field.Name + " = new DevExpress.XtraEditors.TextEdit();\n");
                    case Field.DATE:
                        return ("          this.dateEditor" + field.Name + " = new Tercom.RealIT.CommonGUI.DateEditor();\n");
                    case Field.BOOL:
                        return ("          this.chkEdit" + field.Name + " = new DevExpress.XtraEditors.CheckEdit();\n");
                }
                return "";
            }
            if (field is CardFieldRelation)
            {
                CardFieldRelation cfr = (CardFieldRelation)field;

                return ("          this.lookUpEdit" + field.Name + " = new DevExpress.XtraEditors.LookUpEdit();\n");
            }

            if (field is CardFieldAuxList)
            {
                CardFieldAuxList cfal = (CardFieldAuxList)field;
                if (cfal.List != null)
                {
                    return ("          this.control" + cfal.List.Name + " = new " + cfal.List.Name + "();\n");
                }
            }
            return "";
        
        }

        private static String GetFieldsLabelNewDesigner(CardField field)
        {
            return ("          this.label" + field.Name + " = new System.Windows.Forms.Label();\n");
        }

        private  String GetFieldsDesign(CardField field, int locationX, int locationY, int sizeX, int sizeY, int tabIndex)
        {
            StringBuilder result= new StringBuilder();

            if (field is CardFieldSimple)
            {
                switch (((CardFieldSimple)field).Field.Type)
                {
                    case Field.STRING:
                    case Field.INT:
                        result.AppendFormat("// \n // textEdit"+field.Name+" \n // \n");
                        result.AppendFormat("this.textEdit{0}.EditValue = \"\"; \n", field.Name);
                        result.AppendFormat("this.textEdit{0}.Location = new System.Drawing.Point({1}, {2}); \n",field.Name, locationX, locationY);
                        result.AppendFormat("this.textEdit{0}.Name = \"textEdit{0}\"; \n", field.Name);
                        if (((((CardFieldSimple)field).Field.Type)).Equals(Field.INT))
                        {
                            result.AppendFormat("this.textEdit{0}.Properties.Mask.BeepOnError = true; \n", field.Name);
                            result.AppendFormat("this.textEdit{0}.Properties.Mask.EditMask = \"[0-9]*\"; \n", field.Name);
                            result.AppendFormat("this.textEdit{0}.Properties.Mask.MaskType = DevExpress.XtraEditors.Mask.MaskType.RegEx ;\n", field.Name);
                        }
                        result.AppendFormat("this.textEdit{0}.Size = new System.Drawing.Size({1}, {2});\n", field.Name, sizeX, sizeY);
                        result.AppendFormat("this.textEdit{0}.TabIndex = {1};\n", field.Name, tabIndex);
                        return result.ToString();

                    case Field.DECIMAL:
                        result.AppendFormat("// \n // textEdit" + field.Name + " \n // \n");
                        result.AppendFormat("this.textEdit{0}.EditValue = \"\"; \n", field.Name);
                        result.AppendFormat("this.textEdit{0}.Location = new System.Drawing.Point({1}, {2}); \n", field.Name, locationX, locationY);
                        result.AppendFormat("this.textEdit{0}.Name = \"textEdit{0}\"; \n", field.Name);
                        if (((((CardFieldSimple)field).Field.Type)).Equals(Field.DECIMAL))
                        {
                            //result.AppendFormat("this.textEdit{0}.Properties.Mask.BeepOnError = true; \n", field.Name);
                            //result.AppendFormat("this.textEdit{0}.Properties.Mask.EditMask = \"[0-9]*\"; \n", field.Name);
                            //result.AppendFormat("this.textEdit{0}.Properties.Mask.MaskType = DevExpress.XtraEditors.Mask.MaskType.RegEx ;\n", field.Name);
                        }
                        result.AppendFormat("this.textEdit{0}.Size = new System.Drawing.Size({1}, {2});\n", field.Name, sizeX, sizeY);
                        result.AppendFormat("this.textEdit{0}.TabIndex = {1};\n", field.Name, tabIndex);
                        return result.ToString();

                    case Field.DATE:
                        result.AppendFormat("this.dateEditor{0}.Location = new System.Drawing.Point({1}, {2}); \n", field.Name, locationX, locationY);
                        result.AppendFormat("this.dateEditor{0}.Name = \"dateEditor{0}\"; \n", field.Name);
                        result.AppendFormat("this.dateEditor{0}.Size = new System.Drawing.Size(137, 23); \n", field.Name);
                        result.AppendFormat("this.dateEditor{0}.TabIndex = {1}; \n", field.Name, tabIndex);
                        return result.ToString();
                    case Field.BOOL:
                        result.AppendFormat("// \n // chkEdit" + field.Name + " \n // \n");
                        result.AppendFormat("this.chkEdit{0}.Location = new System.Drawing.Point({1}, {2}); \n", field.Name, locationX, locationY);
                        result.AppendFormat("this.chkEdit{0}.Name = \"chkEdit{0}\"; \n", field.Name);
                        result.AppendFormat("this.chkEdit{0}.Properties.Caption = \"\"; \n", field.Name);
                        result.AppendFormat("this.chkEdit{0}.Size = new System.Drawing.Size({1}, {2});\n", field.Name, sizeX, sizeY);
                        result.AppendFormat("this.chkEdit{0}.TabIndex = {1};\n", field.Name, tabIndex);
                        return result.ToString();
                }
                return "";
            }
            if (field is CardFieldRelation)
            {
                CardFieldRelation cfr = (CardFieldRelation)field;

                result.AppendFormat("// \n // lookUpEdit{0}\n //\n", field.Name);
                result.AppendFormat("this.lookUpEdit{0}.Location = new System.Drawing.Point({1}, {2}); \n", field.Name, locationX, locationY);
                result.AppendFormat("this.lookUpEdit{0}.Name = \"lookUpEdit{0}\";\n", field.Name);
                result.AppendFormat("this.lookUpEdit{0}.Properties.Buttons.AddRange(new DevExpress.XtraEditors.Controls.EditorButton[] {{\n",field.Name);
                result.AppendFormat("   new DevExpress.XtraEditors.Controls.EditorButton(DevExpress.XtraEditors.Controls.ButtonPredefines.Combo)}});\n",field.Name);
                result.AppendFormat("this.lookUpEdit{0}.Size = new System.Drawing.Size({1}, {2});\n", field.Name, sizeX, sizeY);
                result.AppendFormat("this.lookUpEdit{0}.TabIndex = {1};\n", field.Name, tabIndex);
                
                return result.ToString();
            }
            if (field is CardFieldAuxList)
            {
                CardFieldAuxList cfal = (CardFieldAuxList)field;
                if (cfal.List != null)
                {
                    result.AppendFormat("// \n // control{0}\n //\n", field.Name);


                    result.AppendFormat("this.control{0}.Dock = System.Windows.Forms.DockStyle.Fill;\n", cfal.List.Name);
                    result.AppendFormat("this.control{0}.LinkedColumn = \"{1}Id\";\n", cfal.List.Name, card.Class.Name);
                    result.AppendFormat("this.control{0}.LinkedID = null;\n", cfal.List.Name);
                    result.AppendFormat("this.control{0}.LinkedTable = null;\n", cfal.List.Name);
                    result.AppendFormat("this.control{0}.Location = new System.Drawing.Point(3, 3);\n", cfal.List.Name);
                    result.AppendFormat("this.control{0}.Name = \"control{0}\";\n", cfal.List.Name);
                    result.AppendFormat("this.control{0}.Size = new System.Drawing.Size(378, 194);\n", cfal.List.Name);
                    result.AppendFormat("this.control{0}.TabIndex = 0;\n", cfal.List.Name);







                }
                return result.ToString();
            }

            return "";
        }

        private static String GetFieldsLabelDesign(CardField field, int locationX, int locationY, int sizeX, int sizeY, int tabIndex)
        {
            StringBuilder result = new StringBuilder();

            result.AppendFormat("// \n // label{0} \n // \n", field.Name);
            result.AppendFormat("this.label{0}.AutoSize = true;\n", field.Name);
            result.AppendFormat("this.label{0}.Location = new System.Drawing.Point({1}, {2});\n", field.Name, locationX, locationY);
            result.AppendFormat("this.label{0}.Name = \"label{0}\";\n", field.Name);
            result.AppendFormat("this.label{0}.Size = new System.Drawing.Size({1}, {2});\n", field.Name,sizeX, sizeY);
            result.AppendFormat("this.label{0}.TabIndex = {1};\n", field.Name, tabIndex);
            result.AppendFormat("this.label{0}.Text = \"{1}\";\n", field.Name, field.LogicName);

            return result.ToString();
        }

        private static String GetTabDesign(CardTab tab, int tabNumber)
        {
            StringBuilder result = new StringBuilder();


            result.AppendFormat("// \n // {0} \n // \n ", GetFieldName(tab, tabNumber));

            foreach (CardField f in tab.Fields)
            {
                if (f is CardFieldAuxList)
                {
                    if (((CardFieldAuxList)f).List==null)
                    {
                        continue;   
                    }
                }
                result.AppendFormat("this.{0}.Controls.Add(this.{1}); \n", GetFieldName(tab, tabNumber), GetFieldName(f));
                result.AppendFormat("this.{0}.Controls.Add(this.{1}); \n", GetFieldName(tab, tabNumber), "label" + f.Name);
                
            }
            result.AppendFormat("this.{0}.Location = new System.Drawing.Point(4, 22); \n", GetFieldName(tab, tabNumber));
            result.AppendFormat("this.{0}.Name = \"tabPage{0}\"; \n", GetFieldName(tab, tabNumber));
            result.AppendFormat("this.{0}.Size = new System.Drawing.Size(384, 223); \n", GetFieldName(tab, tabNumber));
            result.AppendFormat("this.{0}.TabIndex = {1}; \n", GetFieldName(tab, tabNumber), tabNumber);
            result.AppendFormat("this.{0}.Text = \"{1}\"; \n", GetFieldName(tab, tabNumber), tab.LogicName);

            return result.ToString();
        }

        private static String GetFieldName(CardField field)
        {
            if (field is CardFieldSimple)
            {
                switch (((CardFieldSimple)field).Field.Type)
                {
                    case Field.STRING:
                    case Field.INT:
                    case Field.DECIMAL:
                        return ("textEdit" + field.Name);
                    case Field.DATE:
                        return ("dateEditor" + field.Name);
                    case Field.BOOL:
                        return ("chkEdit" + field.Name);

                }
                return "";
            }
            if (field is CardFieldRelation)
            {
                CardFieldRelation cfr = (CardFieldRelation)field;

                return ("lookUpEdit" + field.Name);
            }
            if (field is CardFieldAuxList)
            {
                CardFieldAuxList cfal = (CardFieldAuxList)field;
                if (cfal.List != null)
                {
                    return ("control" + cfal.List.Name);
                }
            }
            return "";

        }

        private static String GetFieldName(CardTab tab, int tabIndex)
        {
            if (tabIndex > 0)
            {
                return "tabPage" + tabIndex;
            }
            else
            {
                return "tabPageGeneral";
            }
        }

        private static int GetFieldHeight(CardField field)
        {
            if (field is CardFieldSimple)
            {
                switch (((CardFieldSimple)field).Field.Type)
                {

                    case Field.STRING:
                        string controlName = "TextEdit";
                        if ((((CardFieldSimple)field).Additional != null) && (((CardFieldSimple)field).Additional.Equals(CardFieldSimple.MULTILINE)))
                        {
                            return FIELD__MULTILINE_SIZE_Y;
                        }
                        return FIELD_SIZE_Y;
                    case Field.INT:
                    case Field.DECIMAL:
                        return FIELD_SIZE_Y;

                    case Field.DATE:
                        return FIELD_SIZE_Y;

                }
                return FIELD_SIZE_Y;
            }
            if (field is CardFieldRelation)
            {
                return FIELD_SIZE_Y;
            }
            if (field is CardFieldAuxList)
            {
                return FIELD_SIZE_AUX_LIST;
            }
            return FIELD_SIZE_Y;
        }
     


    }
}
