﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;
using FormGenerator.Repository;

namespace FormGenerator.View
{
    public partial class ListProperties : BaseForm
    {
        private List list;

        public ListProperties(List list)
        {
            this.list = list;
            InitializeComponent();

            InitializeTree();
            
            Text = list.LogicName + " - " + ((this.list is Tree)?"Tree":"List")+ " Properties";
            InitializeProperties();

            foreach (Folder folder in Repository.Repository.Instance.Folders)
            {
                comboBoxFolder.Items.Add(folder);
                if (folder.Equals(list.Folder))
                {
                    comboBoxFolder.SelectedItem = folder;
                }
            }

        }

        private void InitializeTree()
        {
            viewTreeView.Nodes.Clear();
            checkedListBoxColumnsOrder.Items.Clear();
            if (list.ListTreeRoot == null)
            {
                viewTreeView.Nodes.Add(BuildViewTree(list.CreateListTree()));
            }
            else
            {
                viewTreeView.Nodes.Add(BuildViewTree(list.ListTreeRoot));
            }
            viewTreeView.ExpandAll();
            if (checkedListBoxColumnsOrder.SelectedItem != null)
            {
                viewTreeView.Focus();
                viewTreeView.SelectedNode = ((ViewAttributeNode)(checkedListBoxColumnsOrder.SelectedItem));

            }
            CheckSelectedColumns();
        }

        private void InitializeProperties()
        {
            comboBoxLocatorField.Items.Add("NO");
            foreach (Field f in list.ListTreeRoot.Class.Fields)
            {
                comboBoxLocatorField.Items.Add(f);
            }

            if (list.Locator == null)
            {
                comboBoxLocatorField.SelectedIndex = 0;
            }
            else
            {
                comboBoxLocatorField.SelectedItem = list.Locator;
            }
            
            comboBoxCard.Items.Add("NO");
            foreach (Card c in Repository.Repository.Instance.Cards)
            {
                if( c.Class.Equals(list.ListTreeRoot.Class))
                {
                    comboBoxCard.Items.Add(c);
                }
            }
            
            if (list.Card == null)
            {
                comboBoxCard.SelectedIndex = 0;
            }
            else
            {
                comboBoxCard.SelectedItem = list.Card;
            }

            listNameTextBox.Text = list.Name;
            logicNameTextBox.Text = list.LogicName;
            checkBoxIsAux.Checked = list.IsAuxiliary;

        }

        protected override void SaveData()
        {
            base.SaveData();

            if (comboBoxCard.SelectedItem is Card)
            {
                list.Card = (Card)(comboBoxCard.SelectedItem);
            }
            else
            {
                list.Card = null;
            }

            if (comboBoxLocatorField.SelectedItem is Field)
            {
                list.Locator = (Field)comboBoxLocatorField.SelectedItem;
            }
            else
            {
                list.Locator = null;
            }

            list.Name = listNameTextBox.Text; 
            list.LogicName = logicNameTextBox.Text;
            list.IsAuxiliary = checkBoxIsAux.Checked;

            list.Folder = (Folder)comboBoxFolder.SelectedItem;
        
        }

        private ViewClassNode BuildViewTree(ListTreeNodeClass root)
        {
            ViewClassNode viewRoot = new ViewClassNode(root);
            viewRoot.ContextMenuStrip = filterContextMenuStrip;

            foreach (ListTreeNode node in root.Childs)
            {
                if (node is ListTreeNodeAttribute)
                {
                    ViewAttributeNode newNode = new ViewAttributeNode((ListTreeNodeAttribute)node);
                    newNode.ContextMenuStrip = attributeContextMenuStrip;
                    newNode.MakeFilter();
                    viewRoot.Nodes.Add(newNode);
                    //checkedListBoxColumnsOrder.Items.Add(newNode, ((ListTreeNodeAttribute)node).GenerateColumn);
                    InsertColumn(newNode.Node.ColumnNumber, newNode);
                }
                if (node is ListTreeNodeClass)
                {
                    ViewClassNode newNode = BuildViewTree((ListTreeNodeClass)node);
                    newNode.ContextMenuStrip = filterContextMenuStrip;
                    newNode.MakeFilter();
                    viewRoot.Nodes.Add(newNode);
                }
            }

            return viewRoot;

        }
        /// <summary>
        /// Inserts a new column to the column orders list to thecorresponding place
        /// </summary>
        private void InsertColumn(int index, ViewAttributeNode newNode)
        {
            SortedList<int,ViewAttributeNode> list = new SortedList<int,ViewAttributeNode>();
            list.Add(index, newNode);
            foreach(Object item in checkedListBoxColumnsOrder.Items)
            {
                while (list.ContainsKey(((ViewAttributeNode)item).Node.ColumnNumber))
                {
                    ((ViewAttributeNode)item).Node.ColumnNumber++;
                }
                list.Add(((ViewAttributeNode)item).Node.ColumnNumber,(ViewAttributeNode)item);
            }
            
            checkedListBoxColumnsOrder.Items.Clear();
            foreach (ViewAttributeNode node in list.Values)
            {
                checkedListBoxColumnsOrder.Items.Add(node);
            }


        }

        /// <summary>
        /// make selected columns checked
        /// </summary>
        private void CheckSelectedColumns()
        {

            for (int i = 0; i < checkedListBoxColumnsOrder.Items.Count; i++)
            {
                checkedListBoxColumnsOrder.SetItemChecked(i,(((ViewAttributeNode)checkedListBoxColumnsOrder.Items[i]).Node.GenerateColumn));
            }

        }

        private void filterContextMenuStrip_Opening(object sender, CancelEventArgs e)
        {
           // if (viewTreeView)


        }

        private void ListProperties_Activated(object sender, EventArgs e)
        {
            viewTreeView.Nodes.Clear();
            InitializeTree();
        }

        private void makeRootToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //MAKE ROOT
            
            if ( viewTreeView.SelectedNode is ViewClassNode)
            {
                ListTreeNodeClass newRoot = ((ViewClassNode)(viewTreeView.SelectedNode)).Node;
                makeRoot(newRoot);
                newRoot.Parent = null;
                list.ListTreeRoot = newRoot;
            }
            InitializeTree();
        }

        private void makeRoot(ListTreeNodeClass node)
        {
            if (node.Parent != null)
            {
                makeRoot((ListTreeNodeClass)node.Parent);
                node.Childs.Add(node.Parent);
                node.Parent.Childs.Remove(node);
                node.Parent.Parent = node;
            }
        }
        
        private void showAttributeProperties(object sender, EventArgs e)
        {

            System.Windows.Forms.Form form = new FilterProperties(((ViewAttributeNode)(viewTreeView.SelectedNode)).Node);
            form.ShowDialog();
            InitializeTree();
        }

        private void showClassProperties(object sender, EventArgs e)
        {
            System.Windows.Forms.Form form = new FilterProperties(((ViewClassNode)(viewTreeView.SelectedNode)).Node);
            form.Show();
        }

        private void viewTreeView_MouseClick(object sender, MouseEventArgs e)
        {
            TreeNode tnClicked = viewTreeView.GetNodeAt(e.X, e.Y);
            viewTreeView.SelectedNode = tnClicked;
        }

        private void filterContextMenuStrip_Opened(object sender, EventArgs e)
        {

            ListTreeNode parentNode = ((ViewClassNode)(viewTreeView.SelectedNode)).Node.Parent;

            makeRootToolStripMenuItem.Enabled = !(parentNode == null);
            propertiesToolStripMenuItem.Enabled = !(parentNode == null);
            deleteClassToolStripMenuItem.Enabled = !(parentNode == null);

            toolStripComboBoxClasses.SelectedIndex = -1;
            toolStripComboBoxClasses.Items.Clear();
            Class c = ((ViewClassNode)(viewTreeView.SelectedNode)).Node.Class;
            foreach( Class slave in Repository.Repository.Instance.GetSlaveClasses(c))
            {
                if (parentNode != null)
                {
                    if (slave == ((ListTreeNodeClass)(parentNode)).Class)
                    {
                        continue;
                    }
                }
                    bool flag = false;
                    foreach (ListTreeNode node in ((ViewClassNode)(viewTreeView.SelectedNode)).Node.Childs)
                    {
                        if (node is ListTreeNodeClass)
                        {
                            if (slave == ((ListTreeNodeClass)node).Class)
                            {
                                flag = true;
                                continue;
                            }
                        }
                    }
                    if (flag)
                    {
                        continue;
                    }
                
                toolStripComboBoxClasses.Items.Add(slave);
            }
            foreach (Class master in Repository.Repository.Instance.GetMasterClasses(c))
            {
                if (parentNode != null)
                {
                    if (master == ((ListTreeNodeClass)(parentNode)).Class)
                    {
                        continue;
                    }
                }
                    bool flag = false;
                    foreach (ListTreeNode node in ((ViewClassNode)(viewTreeView.SelectedNode)).Node.Childs)
                    {
                        if (node is ListTreeNodeClass)
                        {
                            if (master == ((ListTreeNodeClass)node).Class)
                            {
                                flag = true;
                                continue;
                            }
                        }
                    }
                    if (flag)
                    {
                        continue;
                    }
                
                toolStripComboBoxClasses.Items.Add(master);
            }

        }

        private void toolStripComboBoxClasses_Click(object sender, EventArgs e)
        {

        }

        private void toolStripComboBoxClasses_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (toolStripComboBoxClasses.Items.Count == 0)
            {
                return;
            }
            Class selectedClass = (Class)(toolStripComboBoxClasses.SelectedItem);
            ListTreeNodeClass newClassNode = new ListTreeNodeClass();
            newClassNode.Class = selectedClass;
            newClassNode.Parent = ((ViewClassNode)(viewTreeView.SelectedNode)).Node;
            foreach (Field f in  selectedClass.Fields)
            {
                ListTreeNodeAttribute newAttributeNode = new ListTreeNodeAttribute(f);
                newAttributeNode.Parent = newClassNode;
                newClassNode.Childs.Add(newAttributeNode);
            }

            ((ViewClassNode)(viewTreeView.SelectedNode)).Node.Childs.Add(newClassNode);
            toolStripComboBoxClasses.Items.Clear();
            filterContextMenuStrip.Close();

        }

        private void deleteClassToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ListTreeNode parentNode = ((ViewClassNode)(viewTreeView.SelectedNode)).Node.Parent;
            parentNode.Childs.Remove(((ViewClassNode)(viewTreeView.SelectedNode)).Node);
            InitializeTree();
        }

      

        private void viewTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            
        }

        private void viewTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (viewTreeView.SelectedNode != null)
            {
                if (viewTreeView.SelectedNode is ViewAttributeNode)
                {
                    ViewAttributeNode viewNode = (ViewAttributeNode)viewTreeView.SelectedNode;
                    checkedListBoxColumnsOrder.ClearSelected();
                    checkedListBoxColumnsOrder.SelectedItems.Add(viewNode);
                }
                else
                {
                    //checkedListBoxColumnsOrder.ClearSelected();
                }
            }
        }

        private void checkedListBoxColumnsOrder_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (checkedListBoxColumnsOrder.SelectedItem != null)
            {
                viewTreeView.Focus();
                viewTreeView.SelectedNode = ((ViewAttributeNode)(checkedListBoxColumnsOrder.SelectedItem));

            }
        }

        

        private void buttonUp_Click(object sender, EventArgs e)
        {
            if (checkedListBoxColumnsOrder.SelectedItem != null)
            {
                int index = checkedListBoxColumnsOrder.SelectedIndex;
                if (index>0)
                {
                    Object p = checkedListBoxColumnsOrder.Items[index];
                    checkedListBoxColumnsOrder.Items[index] = checkedListBoxColumnsOrder.Items[index - 1];
                    checkedListBoxColumnsOrder.Items[index - 1] = p;
                }
                ((ViewAttributeNode)(checkedListBoxColumnsOrder.Items[index])).Node.ColumnNumber++;
                ((ViewAttributeNode)(checkedListBoxColumnsOrder.Items[index - 1])).Node.ColumnNumber--;
            
            
            
            }
            CheckSelectedColumns();
        }

        private void buttonDown_Click(object sender, EventArgs e)
        {
            if (checkedListBoxColumnsOrder.SelectedItem != null)
            {
                int index = checkedListBoxColumnsOrder.SelectedIndex;
                if (index < checkedListBoxColumnsOrder.Items.Count-1)
                {
                    checkedListBoxColumnsOrder.SelectedIndex++;

                    Object p = checkedListBoxColumnsOrder.Items[index];
                    checkedListBoxColumnsOrder.Items[index] = checkedListBoxColumnsOrder.Items[index + 1];
                    checkedListBoxColumnsOrder.Items[index + 1] = p;

                    ((ViewAttributeNode)(checkedListBoxColumnsOrder.Items[index])).Node.ColumnNumber --;
                    ((ViewAttributeNode)(checkedListBoxColumnsOrder.Items[index+1])).Node.ColumnNumber ++;
                }
            }
            CheckSelectedColumns();
        }

        private void checkedListBoxColumnsOrder_ItemCheck(object sender, ItemCheckEventArgs e)
        {
           
            ((ViewAttributeNode)checkedListBoxColumnsOrder.Items[e.Index]).Node.GenerateColumn = e.NewValue.Equals(CheckState.Checked);

        }

    }
}
