﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;
using FormGenerator.Repository.Forms;
using FormGenerator.Generate;
using FormGenerator.Forms;
using FormGenerator.View.ListViewItems;
using FormGenerator.View.Relationships;

namespace FormGenerator.View
{
    public partial class FormsList : System.Windows.Forms.Form
    {

        public FormsList()
        {
            Repository.Repository.Instance.LoadGeneratingParameters();
            InitializeComponent();
            InitializeFormsList();
            InitializeFolders();
        }

        private void InitializeFormsList()
        {
            FormsListView.Groups.Clear();
            FormsListView.Items.Clear();

            ListViewGroup cardListViewGroup = new ListViewGroup("Cards");

            FormsListView.Groups.Add(cardListViewGroup);
            if (Repository.Repository.Instance.Cards.Count > 0)
            {

                foreach (Card card in Repository.Repository.Instance.Cards)
                {
                    if (comboBoxFolder.SelectedItem!="ALL")
                    {
                        if (card.Folder != comboBoxFolder.SelectedItem)
                        {
                            continue;
                        }
                    }
                    
                    CardListViewItem listViewItem = new CardListViewItem();
                    listViewItem.Text = card.LogicName;
                    listViewItem.Card = card;
                    listViewItem.Group = cardListViewGroup;
                    ListViewItem.ListViewSubItem subItemName = new ListViewItem.ListViewSubItem(listViewItem, card.Name);
                    ListViewItem.ListViewSubItem subItemClass = new ListViewItem.ListViewSubItem(listViewItem, card.Class.LogicName);
                    listViewItem.SubItems.Add(subItemName);
                    listViewItem.SubItems.Add(subItemClass);
                    FormsListView.Items.Add(listViewItem);
                }
            }
            ListViewGroup listListViewGroup = new ListViewGroup("Lists");

            FormsListView.Groups.Add(listListViewGroup);

            if (Repository.Repository.Instance.Lists.Count > 0)
            {

                foreach (List list in Repository.Repository.Instance.Lists)
                {

                    if (comboBoxFolder.SelectedItem != "ALL")
                    {
                        if (list.Folder != comboBoxFolder.SelectedItem)
                        {
                            continue;
                        }
                    }

                    ListListViewItem listViewItem = new ListListViewItem();
                    listViewItem.Text = list.LogicName;
                    listViewItem.List = list;
                    listViewItem.Group = listListViewGroup;
                    
                    ListViewItem.ListViewSubItem subItemName = new ListViewItem.ListViewSubItem(listViewItem, list.Name);
                    ListViewItem.ListViewSubItem subItemClass = new ListViewItem.ListViewSubItem(listViewItem, "");

                    listViewItem.SubItems.Add(subItemName);
                    listViewItem.SubItems.Add(subItemClass);
                    FormsListView.Items.Add(listViewItem);
                }

            }
            //---
            ListViewGroup treeListViewGroup = new ListViewGroup("Trees");

            FormsListView.Groups.Add(treeListViewGroup);

            if (Repository.Repository.Instance.Trees.Count > 0)
            {

                foreach (Tree tree in Repository.Repository.Instance.Trees)
                {

                    if (comboBoxFolder.SelectedItem != "ALL")
                    {
                        if (tree.Folder != comboBoxFolder.SelectedItem)
                        {
                            continue;
                        }
                    }

                    TreeListViewItem treeViewItem = new TreeListViewItem();
                    treeViewItem.Text = tree.LogicName;
                    treeViewItem.Tree = tree;
                    treeViewItem.Group = treeListViewGroup;

                    ListViewItem.ListViewSubItem subItemName = new ListViewItem.ListViewSubItem(treeViewItem, tree.Name);
                    ListViewItem.ListViewSubItem subItemClass = new ListViewItem.ListViewSubItem(treeViewItem, tree.ListTreeRoot.Class.LogicName);

                    treeViewItem.SubItems.Add(subItemName);
                    treeViewItem.SubItems.Add(subItemClass);
                    FormsListView.Items.Add(treeViewItem);
                }

            }



            //---
            ListViewGroup relationshipListViewGroup = new ListViewGroup("Many-to-many relationships");
            FormsListView.Groups.Add(relationshipListViewGroup);

            if (Repository.Repository.Instance.ManyToManyRelationships.Count > 0)
            {

                foreach (ManyToManyRelationship relation in Repository.Repository.Instance.ManyToManyRelationships)
                {

                    if (comboBoxFolder.SelectedItem != "ALL")
                    {
                        if (relation.Folder != comboBoxFolder.SelectedItem)
                        {
                            continue;
                        }
                    }

                    RelationshipListViewItem listViewItem = new RelationshipListViewItem();
                    listViewItem.Text = relation.LogicName;
                    listViewItem.Relationship = relation;
                    listViewItem.Group = relationshipListViewGroup;

                    ListViewItem.ListViewSubItem subItemName = new ListViewItem.ListViewSubItem(listViewItem, relation.Name);
                    ListViewItem.ListViewSubItem subItemView = new ListViewItem.ListViewSubItem(listViewItem, "");
                    ListViewItem.ListViewSubItem subItemClass = new ListViewItem.ListViewSubItem(listViewItem, "");

                    listViewItem.SubItems.Add(subItemName);
                    listViewItem.SubItems.Add(subItemClass);
                    listViewItem.SubItems.Add(subItemView);
                    FormsListView.Items.Add(listViewItem);
                }

            }

        }

        private void InitializeFolders()
        {
            comboBoxFolder.Items.Clear();
            comboBoxFolder.Items.Add("ALL");
            comboBoxFolder.SelectedIndex = 0;
            foreach (Folder folder in Repository.Repository.Instance.Folders)
            {
                comboBoxFolder.Items.Add(folder);
            }
            buttonEditFolder.Enabled = false;

        }

        private void button1_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.Form form;
            if (comboBoxFolder.SelectedItem.Equals( "ALL"))
            {
                 form = new NewCardForm(null);
            }
            else
            {
                form = new NewCardForm((Folder)(comboBoxFolder.SelectedItem));
            }
            
            form.Show(this);
         

        }

        private void FormsList_Activated(object sender, EventArgs e)
        {
            InitializeFormsList();
        }

        private void FormsListView_DoubleClick(object sender, EventArgs e)
        {

            foreach (ListViewItem item in FormsListView.SelectedItems)
            {
                if (item is CardListViewItem)
                {
                    System.Windows.Forms.Form form = new CardProperties(((CardListViewItem)item).Card);
                    form.Show();
                }
                if (item is ListListViewItem)
                {
                    System.Windows.Forms.Form form = new ListProperties(((ListListViewItem)item).List );
                    form.Show();
                }
                if  (item is TreeListViewItem)
                {
                    System.Windows.Forms.Form form = new ListProperties(((TreeListViewItem)item).Tree);
                    form.Show();
                }
                if (item is RelationshipListViewItem)
                {
                    System.Windows.Forms.Form form = new RelationshipProperties(((RelationshipListViewItem)item).Relationship);
                    form.Show();
                }

            }
        }

        private void newListButton_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.Form form;
            if (comboBoxFolder.SelectedItem.Equals("ALL"))
            {
                form = new NewListForm(null);
            }
            else
            {
                form = new NewListForm((Folder)(comboBoxFolder.SelectedItem));
            }

            form.Show(this);



        }

        private void generateFormButton_Click(object sender, EventArgs e)
        {
            if (FormsListView.SelectedItems.Count>0)
            {  
                ListViewItem selectedItem = (ListViewItem)FormsListView.SelectedItems[0];
                
                //load from saved location
                saveGeneratedFormDialog.SelectedPath = System.Configuration.ConfigurationSettings.AppSettings["FormsOutputPath"];

                String path = saveGeneratedFormDialog.SelectedPath;

                if (saveGeneratedFormDialog.ShowDialog().Equals(DialogResult.OK))
                {
                  
                    if (selectedItem is CardListViewItem)
                    {
                        if (((CardListViewItem)selectedItem).Card.Folder != null)
                        {
                            path = path + "\\" + ((CardListViewItem)selectedItem).Card.Folder.Path;
                        }
                        (new CardGenerator(((CardListViewItem)selectedItem).Card)).Generate(path);
                    }
                    if (selectedItem is ListListViewItem)
                    {
                        if (((ListListViewItem)selectedItem).List.Folder != null)
                        {
                            path = path + "\\" + ((ListListViewItem)selectedItem).List.Folder.Path;
                        }
                        (new ListGenerator(((ListListViewItem)selectedItem).List)).Generate(path);
                    }

                    if (selectedItem is TreeListViewItem)
                    {
                        if (((TreeListViewItem)selectedItem).Tree.Folder != null)
                        {
                            path = path + "\\" + ((TreeListViewItem)selectedItem).Tree.Folder.Path;
                        }
                        (new ListGenerator(((TreeListViewItem)selectedItem).Tree)).Generate(path);
                    }

                    if (selectedItem is RelationshipListViewItem)
                    {
                        if (((RelationshipListViewItem)selectedItem).Relationship.Folder != null)
                        {
                            path = path + "\\" + ((RelationshipListViewItem)selectedItem).Relationship.Folder.Path;
                        }
                        (new RelationshipGenerator(((RelationshipListViewItem)selectedItem).Relationship)).Generate(path);
                    }
                }
            }


        }

        private void buttonGenerateDataBase_Click(object sender, EventArgs e)
        {
            //saveFileDialogGenerateDataBase.FileName = "C:\\Users\\John\\Studies\\REAL\\Projects\\Hospital\\Forms\\DB\\Hospital.mdb";
            if (saveFileDialogGenerateDataBase.ShowDialog().Equals(DialogResult.OK))
            {
                (new DatabaseGenerator()).Generate(saveFileDialogGenerateDataBase.FileName);
            }
        }

        private void buttonSaveToXML_Click(object sender, EventArgs e)
        {
            Repository.Repository.Instance.SaveToXML();
        }

        private void buttonViewEditor_Click(object sender, EventArgs e)
        {
            ViewEditor frm = new ViewEditor();
            frm.Show();
        }

        private void button1_Click_1(object sender, EventArgs e)
        {
            System.Windows.Forms.Form form;
            if (comboBoxFolder.SelectedItem.Equals("ALL"))
            {
                form = new NewRelationForm(null);
            }
            else
            {
                form = new NewRelationForm((Folder)(comboBoxFolder.SelectedItem));
            }

            form.Show(this);

        }

        private void FormsListView_KeyPress(object sender, KeyPressEventArgs e)
        
        {

        }

        private void FormsListView_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyValue == 46)
            {
                foreach (ListViewItem selectedItem in FormsListView.SelectedItems)
                {


                    if (selectedItem is CardListViewItem)
                    {
                        Repository.Repository.Instance.DeleteCard(((CardListViewItem)selectedItem).Card);
                    }
                    if (selectedItem is ListListViewItem)
                    {
                        Repository.Repository.Instance.DeleteList(((ListListViewItem)selectedItem).List);
                    }
                    if (selectedItem is TreeListViewItem)
                    {
                        Repository.Repository.Instance.DeleteTree(((TreeListViewItem)selectedItem).Tree);
                    }
                    if (selectedItem is RelationshipListViewItem)
                    {
                        Repository.Repository.Instance.DeleteRelationship(((RelationshipListViewItem)selectedItem).Relationship);
                    }

                }
            }

            InitializeFormsList();
        }

        private void buttonNewFolder_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.Form frm = new FolderParameters(null);
            frm.ShowDialog();
            InitializeFolders();
        }

        private void comboBoxFolder_SelectedIndexChanged(object sender, EventArgs e)
        {
            buttonEditFolder.Enabled = (comboBoxFolder.SelectedIndex > 0);
            InitializeFormsList();
        }

        private void buttonEditFolder_Click(object sender, EventArgs e)
        {
            if (comboBoxFolder.SelectedIndex > 0)
            {
                System.Windows.Forms.Form frm = new FolderParameters((Folder)comboBoxFolder.SelectedItem);
                frm.ShowDialog();
                InitializeFolders();
            }
            InitializeFormsList();

        }

        private void FormsList_Load(object sender, EventArgs e)
        {

        }

        private void splitContainer1_Panel2_Paint(object sender, PaintEventArgs e)
        {

        }

        private void buttonGenerateMenu_Click(object sender, EventArgs e)
        {
           new MenuGenerator().Generate();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.Form form;
            if (comboBoxFolder.SelectedItem.Equals("ALL"))
            {
                form = new NewTreeForm(null);
            }
            else
            {
                form = new NewTreeForm((Folder)(comboBoxFolder.SelectedItem));
            }

            form.Show(this);
        }

        

      

        

    }
}
