﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class CardProperties : BaseForm
    {
        private Card currentCard;
        public CardProperties(Card card)
        {
            InitializeComponent();
            currentCard = card;
            InitializeTreeView();
            Text = currentCard.LogicName + " - Card Properties";

            cardNameTextBox.Text = currentCard.Name;
            LogicNameTextBox.Text = currentCard.LogicName;
            
            foreach (Folder folder in Repository.Repository.Instance.Folders)
            {
                comboBoxFolder.Items.Add(folder);
                if (folder.Equals(currentCard.Folder))
                {
                    comboBoxFolder.SelectedItem = folder;
                }
            }

        }

        private void InitializeField(CardField field, CardTabNode tabNode)
        {
            if (field is CardFieldAuxList)
            {
                CardAuxListNode auxListNode = new CardAuxListNode();
                auxListNode.AuxListField = (CardFieldAuxList)field;
                auxListNode.ContextMenuStrip = fieldNodeContextMenuStrip;
                if (auxListNode.AuxListField.List != null)
                {
                    auxListNode.Text = auxListNode.AuxListField.List.LogicName;
                }
                else
                {
                    auxListNode.Text = auxListNode.AuxListField.SlaveClass.LogicName;
                }
                tabNode.Nodes.Add(auxListNode);
            }
            else
            {
                CardFieldNode fieldNode = new CardFieldNode();
                fieldNode.CardField = field;
                fieldNode.ContextMenuStrip = fieldNodeContextMenuStrip;
                tabNode.Nodes.Add(fieldNode);
            }
        }

        private void InitializeTab(CardTab tab, CardTabNode tabNode)
        {

            tabNode.Tab = tab;
            tabNode.Nodes.Clear();
            foreach (CardField field in tab.Fields)
            {
                InitializeField(field, tabNode);
            }
            tabNode.ContextMenuStrip = tabNodeContextMenuStrip;
        }

        public void InitializeTreeView()
        {
            FieldsTreeView.Nodes.Clear();
            foreach (CardTab tab in currentCard.Tabs)
            {
                CardTabNode tabNode = new CardTabNode();
                InitializeTab(tab, tabNode);
                FieldsTreeView.Nodes.Add(tabNode);

            }


        }

        private void FieldNodeContextMenuStrip_Opening(object sender, CancelEventArgs e)
        {

        }

        private void CardProperties_Activated(object sender, EventArgs e)
        {
            //InitializeTreeView();
        }

        private void Properties_Click(object sender, EventArgs e)
        {

            // TreeNode selectedNode = (TreeNode)(((ContextMenuStrip)(((ToolStripMenuItem)sender).Owner)).SourceControl);
            if (FieldsTreeView.SelectedNode is CardFieldNode)
            {
                if (((CardFieldNode)FieldsTreeView.SelectedNode).CardField is CardFieldSimple)
                {

                    System.Windows.Forms.Form form = new CardFieldSimpleProperties(((CardFieldNode)FieldsTreeView.SelectedNode).CardField);
                    form.ShowDialog();

                }
                if (((CardFieldNode)FieldsTreeView.SelectedNode).CardField is CardFieldRelation)
                {

                    System.Windows.Forms.Form form = new CardFieldRelationProperties((CardFieldRelation)(((CardFieldNode)FieldsTreeView.SelectedNode).CardField));
                    form.ShowDialog();

                }

            }
            if (FieldsTreeView.SelectedNode is CardAuxListNode)
            {
                if (((CardAuxListNode)FieldsTreeView.SelectedNode) is CardAuxListNode)
                {

                    System.Windows.Forms.Form form = new AuxListProperties(((CardAuxListNode)FieldsTreeView.SelectedNode));
                    form.ShowDialog();

                }

            }
            if (FieldsTreeView.SelectedNode is CardTabNode)
            {
                System.Windows.Forms.Form form = new CardTabProperties(((CardTabNode)FieldsTreeView.SelectedNode).Tab);
                form.ShowDialog();
                InitializeTab(((CardTabNode)FieldsTreeView.SelectedNode).Tab, (CardTabNode)FieldsTreeView.SelectedNode);
            }
            FieldsTreeView.Refresh();

        }

        private void Delete_Click(object sender, EventArgs e)
        {
            if (FieldsTreeView.SelectedNode is CardFieldNode)
            {
                ((CardTabNode)FieldsTreeView.SelectedNode.Parent).Tab.Fields.Remove(((CardFieldNode)FieldsTreeView.SelectedNode).CardField);

                FieldsTreeView.SelectedNode.Remove();
            }


        }

        private void tabNodeContextMenuStrip_Opening(object sender, CancelEventArgs e)
        {

        }

        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {



            if (FieldsTreeView.SelectedNode is CardTabNode)
            {
                System.Windows.Forms.Form form = new AddNewCardField(currentCard, ((CardTabNode)FieldsTreeView.SelectedNode).Tab);
                form.ShowDialog();
                InitializeTab(((CardTabNode)FieldsTreeView.SelectedNode).Tab, (CardTabNode)FieldsTreeView.SelectedNode);
            }



        }

        private void button1_Click(object sender, EventArgs e)
        {
            CardTab tab = new CardTab("");
            tab.LogicName = "";
            currentCard.Tabs.Add(tab);

            CardTabNode cardTabNode = new CardTabNode();
            cardTabNode.Tab = tab;
            tab.LogicName = "NewTab";
            string s = cardTabNode.Text;
            FieldsTreeView.Nodes.Add(cardTabNode);
            FieldsTreeView.SelectedNode = cardTabNode;
            Properties_Click(sender, e);

        }

        private void FieldsTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            TreeNode tnClicked = FieldsTreeView.GetNodeAt(e.X, e.Y);
            FieldsTreeView.SelectedNode = tnClicked;
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            //delete tab
            if (FieldsTreeView.SelectedNode is CardTabNode)
            {
                currentCard.Tabs.Remove(((CardTabNode)FieldsTreeView.SelectedNode).Tab);

                FieldsTreeView.SelectedNode.Remove();
            }

        }

        private void buttonUp_Click(object sender, EventArgs e)
        {
            MoveNode(true);


          
        }

        private void MoveNode(bool isMoveUp)
        {
            if (FieldsTreeView.SelectedNode is CardTabNode)
            {
                CardTabNode cardTabNode = ((CardTabNode)(FieldsTreeView.SelectedNode));
                CardTab tab = cardTabNode.Tab;
                int index = currentCard.Tabs.IndexOf(tab);
                if (isMoveUp)
                {
                    if (index > 0)
                    {
                        currentCard.Tabs[index] = currentCard.Tabs[index - 1];
                        currentCard.Tabs[index - 1] = tab;
                        InitializeTab(tab, cardTabNode);
                        InitializeTreeView();
                        FieldsTreeView.Focus();
                        FieldsTreeView.SelectedNode = FieldsTreeView.Nodes[index - 1];
                    }
                }
                else
                {
                    if (index < currentCard.Tabs.Count - 1)
                    {
                        currentCard.Tabs[index] = currentCard.Tabs[index + 1];
                        currentCard.Tabs[index + 1] = tab;
                        InitializeTab(tab, cardTabNode);
                        InitializeTreeView();
                        FieldsTreeView.Focus();
                        FieldsTreeView.SelectedNode = FieldsTreeView.Nodes[index + 1];
                    }
                }
            }
            else
            {
                CardTabNode cardTabNode = ((CardTabNode)(FieldsTreeView.SelectedNode).Parent);
                CardTab tab = (cardTabNode).Tab;
                CardField field = ((CardFieldNode)(FieldsTreeView.SelectedNode)).CardField;
                int index = tab.Fields.IndexOf(field);
                if (isMoveUp)
                {
                    if (index > 0)
                    {
                        tab.Fields[index] = tab.Fields[index - 1];
                        tab.Fields[index - 1] = field;
                        InitializeTab(tab, ((CardTabNode)(FieldsTreeView.SelectedNode.Parent)));
                        FieldsTreeView.Refresh();
                        FieldsTreeView.Focus();
                        FieldsTreeView.SelectedNode = cardTabNode.Nodes[index - 1];
                    }
                }
                else
                {
                    if (index < tab.Fields.Count - 1)
                    {
                        tab.Fields[index] = tab.Fields[index + 1];
                        tab.Fields[index + 1] = field;
                        InitializeTab(tab, ((CardTabNode)(FieldsTreeView.SelectedNode.Parent)));
                        FieldsTreeView.Refresh();
                        FieldsTreeView.Focus();
                        FieldsTreeView.SelectedNode = cardTabNode.Nodes[index + 1];
                    }
                }
            }
        }


        protected override void SaveData()
        {
            base.SaveData();

            currentCard.Name = cardNameTextBox.Text;
            currentCard.LogicName = LogicNameTextBox.Text;
            
            currentCard.Folder = (Folder)comboBoxFolder.SelectedItem;
        }

        private void FieldsTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {

        }

        private void buttonDown_Click(object sender, EventArgs e)
        {
            MoveNode(false);
        }


    }
}

