﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;
using FormGenerator.Repository;

namespace FormGenerator.View
{
    public partial class CardFieldRelationProperties : BaseForm
    {
        private CardFieldRelation field;

        public CardFieldRelationProperties(CardFieldRelation cardField)
        {
            InitializeComponent();
            field = cardField;
            logicNameTextBox.Text = field.LogicName;
            Class c = field.Relation.MasterClass;
            
                
            

            foreach (Field f in c.Fields)
            {
                fieldComboBox.Items.Add(f);
                if (field.Field.Equals(f))
                {
                    fieldComboBox.SelectedItem = f;
                }
            }


        }

        protected override void SaveData()
        {
            field.Field = (Field)(fieldComboBox.SelectedItem);
            field.LogicName = logicNameTextBox.Text;
        }
    }
}
