﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class AddNewCardField : System.Windows.Forms.Form
    {
        private Class cardClass;
        private Card card;
        private CardTab tabToAdd;
        public AddNewCardField(Card card, CardTab tabToAdd)
        {
            this.cardClass = card.Class;
            this.card = card;
            this.tabToAdd = tabToAdd;
            InitializeComponent();
            InitializeListView();
        }

        public void InitializeListView()
        {
            ListViewGroup fieldsGroup = new ListViewGroup("Fields");
            fieldsListView.Groups.Add(fieldsGroup);
            
            ListViewGroup relationGroup = new ListViewGroup("Relations");
            fieldsListView.Groups.Add(relationGroup);

            ListViewGroup auxListGroup = new ListViewGroup("Auxiliary Lists");
            fieldsListView.Groups.Add(auxListGroup);
            
            foreach (Field field in cardClass.Fields)
            {
                if (!IsSimpleFieldPlacedToCard(field))
                {
                    FieldListViewItem item = new FieldListViewItem();
                    item.Text = field.LogicName;
                    item.Group = fieldsGroup;
                    item.Field = field;
                    fieldsListView.Items.Add(item);
                }
            }

            foreach (Relation relation in Repository.Repository.Instance.GetMasterClassesRelations(cardClass))
            {
                if (!IsRelationFieldPlacedToCard(relation))
                {
                    RelationListViewItem item = new RelationListViewItem();
                    item.Text = relation.MasterClass.LogicName;
                    item.Group = relationGroup;
                    item.Relation = relation;
                    fieldsListView.Items.Add(item);
                }
            }

            foreach (Relation relation in Repository.Repository.Instance.GetSlaveClassesRelations(cardClass))
            {
                if (!IsAuxListPlacedToCard(relation.SlaveClass))
                {
                    AuxListListViewItem item = new AuxListListViewItem();
                    item.Text = relation.SlaveClass.LogicName;
                    item.Group = auxListGroup;
                    item.SlaveClass = relation.SlaveClass;
                    fieldsListView.Items.Add(item);
                }
            }
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void addSelectedButton_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in fieldsListView.SelectedItems)
            {
                if (item is FieldListViewItem)
                {
                    tabToAdd.Fields.Add(new CardFieldSimple(((FieldListViewItem)item).Field, ((FieldListViewItem)item).Field.LogicName));
                }
                if (item is RelationListViewItem)
                {
                    Field displayedField = null;
                    if (((RelationListViewItem)item).Relation.MasterClass.Fields.Count > 0)
                    {
                        displayedField = ((RelationListViewItem)item).Relation.MasterClass.Fields[0];
                    }
                    
                        tabToAdd.Fields.Add(new CardFieldRelation(
                            ((RelationListViewItem)item).Relation.MasterClass.LogicName,
                            ((RelationListViewItem)item).Relation,
                            displayedField));

                }
                if (item is AuxListListViewItem)
                {

                    tabToAdd.Fields.Add(new CardFieldAuxList(null, ((AuxListListViewItem)item).SlaveClass));

                }



            }
            this.Close();
        }

        private bool IsAuxListPlacedToCard(Class slaveClass)
        {
            foreach (CardTab tab in card.Tabs)
            {
                foreach (CardField cardField in tab.Fields)
                {
                    if (cardField is CardFieldAuxList)
                    {
                        if (slaveClass.Equals(((CardFieldAuxList)cardField).SlaveClass))
                        {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private bool IsRelationFieldPlacedToCard(Relation relation)
        {
            foreach (CardTab tab in card.Tabs)
            {
                foreach (CardField cardField in tab.Fields)
                {
                    if (cardField is CardFieldRelation)
                    {
                        if (relation.Equals(((CardFieldRelation)cardField).Relation))
                        {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        private bool IsSimpleFieldPlacedToCard(Field field)
        {
            foreach (CardTab tab in card.Tabs)
            {
                foreach (CardField cardField in tab.Fields)
                {
                        if (cardField is CardFieldSimple)
                        {
                            if (((CardFieldSimple)cardField).Field.Equals(field))
                            {
                                return true;
                            }
                        }
                    
                }
            }
            return false;
        }
    }



}
