﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository
{
    public class View:BaseItem
    {
        private List<ClassInView> classes;
        
        private List<Relation> relations;
        
        public View()
        {
            classes = new List<ClassInView>();
            relations = new List<Relation>();

        }

        public View(XElement xelement)
        {
            relations = new List<Relation>();
            classes = new List<ClassInView>();
            
            LogicName = xelement.Attribute("LogicName").Value;
            foreach (XElement c in xelement.Element("Classes").Elements("ClassInView"))
            {
                classes.Add(new ClassInView(c));
            }
            
            foreach (XElement r in xelement.Element("Relations").Elements("Relation"))
            {
                relations.Add(Repository.Instance.GetRelation(r.Attribute("MasterClass").Value, r.Attribute("SlaveClass").Value));
            }

        }

        public List<ClassInView> Classes
        {
            get { return classes; }
            set { classes = value; }
        }

        public List<Relation> Relations
        {
            get { return relations; }
            set { relations = value; }
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("View",
                    new XAttribute("LogicName", this.LogicName),
                    new XElement("Classes", from c in this.Classes select c.XElement),
                    new XElement("Relations", from relation in this.Relations select relation.XElement)
                    );

                return xelement;
            }
        }


    }
}
