﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;
using FormGenerator.Repository.Forms;
using System.Reflection;
using System.Xml.Linq;
using JimBlackler.DocsByReflection;
using System.Xml;
using FormGenerator.Forms;
using System.IO;
using ParseXMIDocument;
using System.Drawing;

namespace FormGenerator.Repository
{
    class Repository
    {
        private string projectName;
        private List<Relation> relations;
        private List<View> views;
        private List<List> lists;
        private List<Tree> trees;
        private List<Card> cards;
        private List<Folder> folders;
        private List<ManyToManyRelationship> manyToManyRelationships;
        private List<Class> classes;
        private List<Enum> enums;
        private List<Connection> connections;
        private List<InformationConnection> informationConnections;

        public List<InformationConnection> InformationConnection
        {
            get { return informationConnections; }
            set { informationConnections = value; }
        }

        public List<Connection> Connections
        {
            get { return connections; }
            set { connections = value; }
        }


        private static Repository instance;

        private Repository()
        {
            classes = new List<Class>();
            relations = new List<Relation>();
            views = new List<View>();
            lists = new List<List>();
            trees = new List<Tree>();
            cards = new List<Card>();
            folders = new List<Folder>();
            enums = new List<Enum>();
            connections = new List<Connection>();
            informationConnections = new List<InformationConnection>();
            manyToManyRelationships = new List<ManyToManyRelationship>();
            LoadDiagrams();
        }

        public static Repository Instance
        {
            get
            {

                if (instance == null)
                {
                    instance = new Repository();
                }
                return instance;
            }
        }

        public string ProjectName
        {
            get { return projectName; }
            set { projectName = value; }
        }
        public List<Enum> Enums
        {
            get { return enums; }
            set { enums = value; }
        } 

        public List<Class> Classes
        {
            get { return classes; }
            set { classes = value; }
        }

        public List<Relation> Relations
        {
            get { return relations; }
            set { relations = value; }
        }

        public List<View> Views
        {
            get { return views; }
            set { views = value; }
        }

        public List<List> Lists
        {
            get { return lists; }
            set { lists = value; }
        }

        public List<Tree> Trees
        {
            get { return trees; }
            set { trees = value; }
        }

        public List<Card> Cards
        {
            get { return cards; }
            set { cards = value; }
        }

        public List<Folder> Folders
        {
            get { return folders; }
            set { folders = value; }
        }

        public List<ManyToManyRelationship> ManyToManyRelationships
        {
            get { return manyToManyRelationships; }
            set { manyToManyRelationships = value; }
        }

        public Relation GetRelation(String master, String slave)
        {
            foreach (Relation r in Relations)
            {
                if ((r.SlaveClass.Equals(GetClass(slave))) && (r.MasterClass.Equals(GetClass(master))))
                {
                    return r;
                }
            }
            return null;
        }

        public Relation GetRelation(Class master, Class slave)
        {
            foreach (Relation r in Relations)
            {
                if ((r.SlaveClass.Equals(slave)) && (r.MasterClass.Equals(master)))
                {
                    return r;
                }

            }
            return null;

        }

        public List<Relation> GetMasterClassesRelations(Class c)
        {
            List<Relation> relations = new List<Relation>();
            foreach (Relation r in Relations)
            {
                if (r.SlaveClass.Equals(c))
                {
                    relations.Add(r);
                }

            }
            return relations;
        }

        public List<Relation> GetSlaveClassesRelations(Class c)
        {
            List<Relation> relations = new List<Relation>();
            foreach (Relation r in Relations)
            {
                if (r.MasterClass.Equals(c))
                {
                    relations.Add(r);
                }

            }
            return relations;
        }

        public List<Class> GetSlaveClasses(Class c)
        {
            List<Class> classes = new List<Class>();
            foreach (Relation r in Relations)
            {
                if (r.MasterClass.Equals(c))
                {
                    classes.Add(r.SlaveClass);
                }
            }
            return classes;
        }

        public List<Class> GetMasterClasses(Class c)
        {
            List<Class> classes = new List<Class>();
            foreach (Relation r in Relations)
            {
                if (r.SlaveClass.Equals(c))
                {
                    classes.Add(r.MasterClass);
                }
            }
            return classes;
        }

        public List<List> GetAuxLists(Class mainClass)
        {
            List<List> lists = new List<List>();
            foreach (List l in Lists)
            {
                if (l.ListTreeRoot.Class.Equals(mainClass) & l.IsAuxiliary)
                {
                    lists.Add(l);
                }
            }
            return lists;
        }

        public Class GetClass(String className)
        {
            foreach (Class c in Classes)
            {
                if (c.Name.Equals(className))
                {
                    return c;
                }

            }
            return null;
        }

        public Class GetClassById(String Id)
        {
            foreach (Class c in Classes)
            {
                if (c.Id.Equals(Id))
                {
                    return c;
                }

            }
            return null;
        }

        public Card GetCard(String name)
        {
            foreach (Card card in Cards)
            {
                if (card.Name.Equals(name))
                {
                    return card;
                }

            }
            return null;
        }

        public List GetList(String name)
        {
            foreach (List list in Lists)
            {
                if (list.Name.Equals(name))
                {
                    return list;
                }

            }
            return null;
        }

        public Folder GetFolder(String folderPath)
        {
            foreach (Folder folder in Folders)
            {
                if (folder.Path.Equals(folderPath))
                {
                    return folder;
                }

            }
            return null;
        }

        public List<List> GetNotAuxListsFromFolder(Folder folder)
        {
            List<List> lists = new List<List>();
            foreach (List l in Lists)
            {
                if (l.Folder.Equals(folder) & !l.IsAuxiliary)
                {
                    lists.Add(l);
                }
            }
            return lists;
        }

        public List<Tree> GetTreesFromFolder(Folder folder)
        {
            List<Tree> trees = new List<Tree>();
            foreach (Tree t in Trees)
            {
                if (t.Folder.Equals(folder))
                {
                    trees.Add(t);
                }
            }
            return trees;
        }

        public List<ManyToManyRelationship> GetRelationshipsFromFolder(Folder folder)
        {
            List<ManyToManyRelationship> relations = new List<ManyToManyRelationship>();
            foreach (ManyToManyRelationship r in ManyToManyRelationships)
            {
                if (r.Folder.Equals(folder))
                {
                    relations.Add(r);
                }
            }
            return relations;
        }

        public Field GetClassField(Class c, String fieldName)
        {
            foreach (Field f in c.Fields)
            {
                if (f.Name.Equals(fieldName))
                {
                    return f;
                }

            }
            return null;
        }

        public Field GetClassField(String className, String fieldName)
        {
            Class c = GetClass(className);

            return GetClassField(c, fieldName);
        }

        public void LoadDiagrams()
        {
            String DiagramsFolderPath = System.Configuration.ConfigurationSettings.AppSettings["SolutionPath"];
            // loading all diagrams from folder
            string[] solutions = Directory.GetFiles(DiagramsFolderPath, "*.sln", SearchOption.AllDirectories);
            foreach (String solution in solutions)
            {
                TextReader tr = new StreamReader(solution);

                String s = tr.ReadLine();


                if (System.Configuration.ConfigurationManager.AppSettings["RepositoryType"].Contains("DLL"))
                {
                    LoadClassStructureVS2008(); 
                    tr.Close();
                    break;
                }

                if (System.Configuration.ConfigurationManager.AppSettings["RepositoryType"].Contains("Diagrams"))
                {
                    LoadClassStructureVS2010();
                    tr.Close();
                    break;
                }
            }

        }

        public void LoadClassStructureVS2008()
        {
            // experiments with loading from dll

            projectName = "ProjectName";

            Assembly assem = Assembly.LoadFrom(System.Configuration.ConfigurationSettings.AppSettings["ModelDllPath"]);
            Type[] types = assem.GetTypes();
            //---
            XElement bpDiagram = XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["BPModelXmlPath"]);
            var pools = (from f in bpDiagram.Descendants("pool")
                         select f).ToList();
            //---
            foreach (Type cls in types)
            {
                if (!cls.IsAbstract)
                {

                    Class classInRepository = new Class(cls.Name, cls.Name);

                    if (!cls.BaseType.FullName.Equals("System.Enum"))
                    {
                        foreach (FieldInfo fieldInfo in cls.GetFields())
                        {
                            Field fieldInRepository = new Field(fieldInfo.Name, fieldInfo.Name, fieldInfo.FieldType.Name);
                            try
                            {
                                XmlElement documentation = DocsByReflection.XMLFromMember(fieldInfo);

                                fieldInRepository.LogicName = documentation["summary"].InnerText.Trim();
                            }
                            catch
                            {
                            }

                            classInRepository.Fields.Add(fieldInRepository);
                        }

                    }
                    else
                    {
                        //Field enumField = new Field("Value", DocsByReflection.XMLFromType(cls)["remarks"].InnerText.Trim(), Field.STRING);
                        // Из-за этого не пашет SaveToXML
                        Enum e = new Enum();
                        e.Class = classInRepository;

                        foreach (FieldInfo fieldInfo in cls.GetFields())
                        {
                            if (fieldInfo.IsStatic)
                            {
                                try
                                {
                                    e.Values.Add(((System.Enum)(fieldInfo.GetValue(null))).GetHashCode(), DocsByReflection.XMLFromMember(fieldInfo)["summary"].InnerText.Trim());
                                }
                                catch{}
                            }
                        }
                        
                        Enums.Add(e);
                        //classInRepository.Fields.Add(enumField);
                    }

                    try
                    {
                        XmlElement documentation = DocsByReflection.XMLFromType(cls);
                        string summary = documentation["summary"].InnerText.Trim();

                        if (!summary.Equals(""))
                        {
                            classInRepository.LogicName = summary;
                        }
                    }
                    catch
                    {

                    }

                    //-------
                    foreach (var pool in pools)
                    {
                        var poolName = pool.Attribute("name").Value;
                        // Проверяем, есть ли соответствующий класс на диаграмме классов
                        if (cls.Name == poolName)
                        {
                            if (!cls.IsAbstract)
                            {
                                // генерим перечисление и привязку (Relation)
                                Enum e = generateEnum(pool);
                                generateRelation(classInRepository, e);
                            }
                        }
                    }
                    //-------
                    AddClass(classInRepository);
                }
            }

            foreach (Type cls in types)
            {
                foreach (PropertyInfo propertyInfo in cls.GetProperties())
                {
                    Relation relationInRepository = new Relation(GetClass(propertyInfo.PropertyType.Name), 
                        Relation.ZERO_ONE, GetClass(cls.Name), Relation.ZERO_MULTIPLE);
                    relationInRepository.Name = "";
                    relationInRepository.LogicName = "";
                    try
                    {
                        XmlElement documentation = DocsByReflection.XMLFromMember(propertyInfo);

                        relationInRepository.LogicName = documentation["summary"].InnerText.Trim();
                    }
                    catch
                    {

                    }
                    AddRelation(relationInRepository);
                }
            }

            //-------
            foreach (var pool in pools)
            {
                var poolName = pool.Attribute("name").Value;
                // если класса нет => создаем перечисление и статический класс + в базе запись с текущим значением
                if (!types.Select(t => t.Name).ToList().Contains(poolName))
                {
                    Enum e = generateEnum(pool);
                    generateStaticClass(pool);
                }
            }
            //-------
            //-------
            LoadInformationConnections();
            LoadConnections();
            //-------
        }
        private void generateStaticClass(XElement pool)
        {
            string className = pool.Attribute("name").Value;
            Class classInRepository = new Class(className, className);

            GenerateStaticClass gsc = new GenerateStaticClass(className);
            gsc.AddField();
            gsc.AddProperties();
            gsc.GenerateCSharpCode();

            AddClass(classInRepository);
        }
        public Enum generateEnum(XElement pool)
        {
            string className = pool.Attribute("name").Value + "StateGenerated";
            Enum e = new Enum();
            Class classInRepository = new Class(className, className);
            int cnt = 1;

            e.Class = classInRepository;
            AddClass(classInRepository);

            foreach (var connection in pool.Element("connections").Descendants("connection"))
            {
                ParseXMI.DiagramElement type = ParseXMI.determineDiagramElementByName(connection.Attribute("sourceType").Value);
                if (ParseXMI.isState(type))
                {
                    e.Values.Add(cnt, connection.Attribute("sourceStateName").Value);
                    cnt++;
                }
                string targetType = connection.Attribute("targetType").Value;
                string targetStateName = connection.Attribute("targetStateName").Value;
                ParseXMI.DiagramElement type1 = ParseXMI.determineDiagramElementByName(targetType);
                if (type1 == ParseXMI.DiagramElement.EndEvent && !e.Values.Values.Contains(targetStateName))
                {
                    e.Values.Add(cnt, targetStateName);
                    cnt++;
                }
            }
            Enums.Add(e);
            return e;
        }
        private void generateRelation(Class cls, Enum e)
        {
            // сначала enum, потом класс
            Relation relationInRepository = new Relation(e.Class, Relation.ZERO_ONE, cls, Relation.ZERO_MULTIPLE);

            Field enumFieldInClass = new Field("status", "Состояние", Field.STRING);
            cls.AddField(enumFieldInClass);
            relationInRepository.Name = "";
            relationInRepository.LogicName = "";
            AddRelation(relationInRepository);                    
        }
        public void LoadInformationConnections()
        {
            XElement bpDiagram = XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["BPModelXmlPath"]);
            var pools = (from f in bpDiagram.Descendants("pool")
                         select f).ToList();

            var listOfIds = pools.Select(pool => new KeyValuePair<string, List<string>>(pool.Attribute("name").Value, pool.Element("connections").Descendants("connection").Select(conn => 
                conn.Attribute("source").Value).ToList())).ToList();

            var infFlows = (from iFlow in bpDiagram.Descendants("informationFlow")
                            select iFlow).ToList();

            foreach (var iFlow in infFlows)
            {
                string sClassName = "";
                string tClassName = "";
                foreach (var pair in listOfIds)
                {
                    if (pair.Value.Contains(iFlow.Attribute("source").Value))
                    {
                        sClassName = pair.Key;
                    }
                    if (pair.Value.Contains(iFlow.Attribute("target").Value))
                    {
                        tClassName = pair.Key;
                    }
                }
                ParseXMI.DiagramElement sourceType = ParseXMI.determineDiagramElementByName(iFlow.Attribute("sourceType").Value);
                ParseXMI.DiagramElement targetType = ParseXMI.determineDiagramElementByName(iFlow.Attribute("targetType").Value);
                InformationConnection infoConnection = new InformationConnection(GetClass(sClassName), GetClass(tClassName),
                    GetClass(iFlow.Attribute("name").Value), iFlow.Attribute("source").Value, iFlow.Attribute("target").Value,
                    sourceType, targetType);
                informationConnections.Add(infoConnection);
            }
        }
        public void LoadConnections()   
        {
            XElement bpDiagram = XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["BPModelXmlPath"]);
            var pools = (from f in bpDiagram.Descendants("pool")
                         select f).ToList();

            foreach (var pool in pools)
            {
                var poolName = pool.Attribute("name").Value;
                var listConnections = pool.Element("connections").Descendants("connection").ToList();
                
                foreach (var connection in listConnections)
                {
                    ParseXMI.DiagramElement sourceType = ParseXMI.determineDiagramElementByName(connection.Attribute("sourceType").Value);
                    ParseXMI.DiagramElement targetType = ParseXMI.determineDiagramElementByName(connection.Attribute("targetType").Value);
                    Connection conn = new Connection(GetClass(poolName),
                        connection.Attribute("source").Value,
                        connection.Attribute("target").Value,
                        connection.Attribute("sourceStateName").Value, 
                        connection.Attribute("targetStateName").Value,
                        connection.Attribute("condition").Value,
                        sourceType,
                        targetType
                        );
                    connections.Add(conn);
                }
            }
        }
        public void LoadClassStructureVS2010()
        {
            String DiagramsFolderPath = System.Configuration.ConfigurationSettings.AppSettings["SolutionPath"] + "\\Diagrams\\";
            // loading all diagrams from folder
            string[] filePaths = Directory.GetFiles(DiagramsFolderPath, "*.classdiagram", SearchOption.AllDirectories);
            foreach (String diagramPath in filePaths)
            {
                LoadClassDiagram2010(diagramPath);
            }


        }

        public void LoadClassDiagram2010(String diagramPath)
        {
            LoadClassesFromDiagram2010(diagramPath);
        }

        public void LoadClassesFromDiagram2010(String diagramPath)
        {
            XElement xml = XElement.Load(diagramPath);
            var classes = from c in xml.Elements(xml.GetDefaultNamespace() + "packagedElements").Elements(xml.GetDefaultNamespace() + "logicalClassDesignerModelHasTypes")
                          select c;
            foreach (XElement c in classes)
            {
                foreach (XElement e in c.Elements())
                {
                    if (e.Name.Equals(xml.GetDefaultNamespace() + "class"))
                    {
                        string className = e.Attribute("name").Value.ToString();
                        string classDescription = className;

                        if (e.Element(xml.GetDefaultNamespace() + "description") != null)
                        {
                            classDescription = e.Element(xml.GetDefaultNamespace() + "description").Value.ToString();
                        }
    Class newClass = new Class(className, classDescription);
                        if (e.Element(xml.GetDefaultNamespace() + "generalsInternal") != null)
                        {

                            if (e.Element(xml.GetDefaultNamespace() + "generalsInternal").Element(xml.GetDefaultNamespace() + "generalization") != null)
                            {
                                newClass.ParentClassId = e.Element(xml.GetDefaultNamespace() + "generalsInternal").Element(xml.GetDefaultNamespace() + "generalization").Element((xml.GetDefaultNamespace() + "classMoniker")).FirstAttribute.Value.ToString();
                            }
                        }

                    
                        newClass.Id = e.Attribute("Id").Value.ToString();
                        
                        LoadFields2010(xml.GetDefaultNamespace(), e, newClass);
                       
                        AddClass(newClass);
                    }
                }
            }

            foreach (XElement c in classes)
            {
                foreach (XElement e in c.Elements())
                {
                    if (e.Name.Equals(xml.GetDefaultNamespace() + "class"))
                    {
                        LoadRelations2010(xml.GetDefaultNamespace(), e, GetClassById(e.Attribute("Id").Value.ToString()));
                    }
                }
            }


            foreach (Class c in Classes)
            {
                if (c.ParentClassId != null)
                {

                    foreach (Field f in GetClassById(c.ParentClassId).Fields)
                    {
                        c.Fields.Add(new Field(f.Name, f.LogicName, f.Type));
                    }
                   

                }
            }


        }

        public void LoadFields2010(XNamespace defaultNamespace, XElement classElement, Class loadingClass)
        {
            if (classElement.Element(defaultNamespace + "ownedAttributesInternal") != null)
            {
                var fields = from i in classElement.Element(defaultNamespace + "ownedAttributesInternal").Elements(defaultNamespace + "property")
                             select i;
                foreach (XElement field in fields)
                {
                    if (field.Name.Equals(defaultNamespace + "property"))
                    {
                        string fieldName = field.Attribute("name").Value.ToString();
                        string fieldDescription = fieldName;
                        string fieldType = Field.STRING;

                        if (field.Element(defaultNamespace + "description") != null)
                        {
                            fieldDescription = field.Element(defaultNamespace + "description").Value.ToString();
                        }
                        try
                        {
                            fieldType = field.Element(defaultNamespace + "type_NamedElement").Element(defaultNamespace + "referencedTypeMoniker").Attribute("LastKnownName").Value.ToString();
                        }
                        catch
                        {

                        }
                        Field newField = new Field(fieldName, fieldDescription, fieldType);
                        newField.Id = field.Attribute("Id").Value.ToString();
                        loadingClass.AddField(fieldName, fieldDescription, fieldType);

                    }

                }
            }



        }

        public void LoadRelations2010(XNamespace defaultNamespace, XElement classElement, Class loadingClass)
        {
            if (classElement.Element(defaultNamespace + "targetEnds") != null)
            {
                var accotiations = from i in classElement.Element(defaultNamespace + "targetEnds").Elements(defaultNamespace + "association")
                             select i;
                foreach (XElement accotiation in accotiations)
                {
                    if (accotiation.Name.Equals(defaultNamespace + "association"))
                    {
                        string secondClassId = "";
                        if (accotiation.Element(defaultNamespace + "classMoniker") != null)
                        {
                            secondClassId = accotiation.Element(defaultNamespace + "classMoniker").Attribute("Id").Value.ToString();
                        }
                        else
                        {
                            secondClassId = accotiation.Element(defaultNamespace + "enumerationMoniker").Attribute("Id").Value.ToString();
                        }
                        string firstClassAccotiationEndId = accotiation.Element(defaultNamespace + "relationshipOwnedElementsInternal").Elements(defaultNamespace + "associationHasOwnedEnds").First().Element(defaultNamespace + "memberEnd").Attribute("Id").Value.ToString();
                        string secondClassAccotiationEndId = ((XElement)(accotiation.Element(defaultNamespace + "relationshipOwnedElementsInternal").Elements(defaultNamespace + "associationHasOwnedEnds").First().NextNode)).Element(defaultNamespace + "memberEnd").Attribute("Id").Value.ToString();

                        Relation relation = new Relation(GetClassById(secondClassId), Relation.ZERO_ONE, loadingClass, Relation.ZERO_MULTIPLE);

                        AddRelation(relation);
                    }

                }
            }



        }

        public void LoadGeneratingParameters()
        {
            var folders = from f in XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]).Elements("Folders").Elements("Folder")
                          select f;
            foreach (XElement folder in folders)
            {
                Folders.Add(new Folder(folder));
            }

            var cards = from c in XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]).Elements("Cards").Elements("Card")
                        select c;
            foreach (XElement card in cards)
            {
                AddCard(new Card(card));
            }

            var views = from v in XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]).Elements("Views").Elements("View")
                        select v;
            foreach (XElement view in views)
            {
                Views.Add(new View(view));
            }

            var lists = from l in XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]).Elements("Lists").Elements("List")
                        select l;
            foreach (XElement list in lists)
            {
                Lists.Add(new List(list));
            }

            var trees = from t in XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]).Elements("Trees").Elements("Tree")
                        select t;
            foreach (XElement tree in trees)
            {
                Trees.Add(new Tree(tree));
            }


            var relationships = from r in XElement.Load(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]).Elements("Relationships").Elements("ManyToManyRelationship")
                                select r;
            foreach (XElement r in relationships)
            {
                ManyToManyRelationships.Add(new ManyToManyRelationship(r));
            }

            foreach (XElement card in cards)
            {
                //
                GetCard(card.Attribute("Name").Value).RestoreTabs(card);
            }
        }

        public void AddClass(Class c)
        {
            classes.Add(c);
        }

        public void AddRelation(Relation relation)
        {
            relations.Add(relation);
        }

        public void AddCard(Card card)
        {
            cards.Add(card);

        }

        public void DeleteCard(Card card)
        {
            cards.Remove(card);

            foreach (List list in lists)
            {
                if (list.Card == card)
                {
                    list.Card = null;
                }
            }
        }

        public void DeleteList(List list)
        {
            lists.Remove(list);

            foreach (Card card in cards)
            {
                foreach (CardTab tab in card.Tabs)
                {
                    foreach (CardField field in tab.Fields)
                    {
                        if (field is CardFieldAuxList)
                        {
                            if (((CardFieldAuxList)field).List == list)
                            {
                                ((CardFieldAuxList)field).List = null;
                            }
                        }
                    }
                }
            }
        }

        public void DeleteTree(Tree tree)
        {
            trees.Remove(tree);
        }


        public void DeleteRelationship(ManyToManyRelationship relation)
        {
            manyToManyRelationships.Remove(relation);
        }

        public void DeleteView(View view)
        {
            Views.Remove(view);
        }

        public void AddNewCard(String name, string logicName, Class c, Folder folder)
        {
            Card card = new Card(name, logicName, c);
            card.Folder = folder;
            cards.Add(card);

        }

        public void AddNewList(String name, string logicName, View view, bool isAuxiliary, Folder folder)
        {
            List list = new List(name, logicName, view, isAuxiliary);
            list.Folder = folder;
            Repository.Instance.Lists.Add(list);

        }

        public void AddNewList(String name, string logicName, Class c, bool isAuxiliary, Folder folder)
        {
            List list = new List(name, logicName, c, isAuxiliary);
            list.Folder = folder;
            Repository.Instance.Lists.Add(list);

        }

        public void AddNewTree(String name, string logicName, Class c, Folder folder)
        {
            Tree tree = new Tree(name, logicName, c, false);
            tree.Folder = folder;
            Repository.Instance.Trees.Add(tree);

        }

        public void AddNewManyToManyRelationship(String name, string logicName, Folder f)
        {
            ManyToManyRelationship relation = new ManyToManyRelationship(name, logicName);
            relation.Folder = f;
            Repository.Instance.ManyToManyRelationships.Add(relation);
        }


        public string TestForLogicalNames()
        {
            StringBuilder errors = new StringBuilder();
            return "";
            //TODO
        }

        public static bool IsHasRecursiveLink(Class c)
        {
            foreach (Relation r in Repository.Instance.Relations)
            {
                if (r.MasterClass.Equals(c) && r.SlaveClass.Equals(c))
                {
                    return true;
                }
            }
            return false;
        }


        public void SaveToXML()
        {
            this.ProjectName = "1";
            XElement repository = new XElement("Repository", new XAttribute("Name", this.ProjectName),
                new XElement("Folders", from folder in this.Folders select folder.XElement),
                new XElement("Cards", from card in this.Cards select card.XElement),
                new XElement("Views", from view in this.Views select view.XElement),
                new XElement("Lists", from list in this.Lists select list.XElement),
                new XElement("Trees", from tree in this.Trees select tree.XElement),
                new XElement("Relationships", from relationship in this.ManyToManyRelationships select relationship.XElement)         
                //TODO: Connections & InformationConnections
                );
            repository.Save(System.Configuration.ConfigurationSettings.AppSettings["ModelXmlPath"]);

        }


    }
}
