﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace ParseXMIDocument
{
    public class Activity : IDiagramObject
    {
        public enum ActivityType
        {
            Script,
            User,
            Abstract,
            Other
        };
        private ActivityType type;

        public ActivityType Type
        {
            get { return type; }
            set { type = value; }
        }

        private string _Name;
        
        public string Name
        {
            get
            {
                return _Name;
            }
            set
            {
                _Name = value;
            }
        }
        public Activity(string name, ActivityType type)
        {
            if (String.IsNullOrEmpty(name))
                throw new ArgumentException("name is null or empty.", "name");
            Name = name;
            Type = type;
        }
    }
}
