﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class ListTreeNodeClass:ListTreeNode
    {
        private Class c;

        private Field filteredField;
        
        public ListTreeNodeClass(): base()
        {

        }
        
        public ListTreeNodeClass(XElement xelement, ListTreeNodeClass parent): base()
        {
            Class = Repository.Instance.GetClass(xelement.Attribute("Class").Value);
            Parent = parent;
            if ((xelement.Attribute("FilteredField") != null) && (xelement.Attribute("FilteredField").Value != ""))
            {
                IsFilter = true;
                FilteredField = Repository.Instance.GetClassField(Class, xelement.Attribute("FilteredField").Value);
            }


            foreach (XElement ltnc in xelement.Element("Children").Elements("ListTreeNodeClass"))
            {
                Childs.Add(new ListTreeNodeClass(ltnc, this));
            }
            foreach (XElement ltna in xelement.Element("Children").Elements("ListTreeNodeAttribute"))
            {
                Childs.Add(new ListTreeNodeAttribute(c, ltna, this));
            }
        }

        public Class Class
        {
            get { return c; }
            set { c = value; }
        }

        public Field FilteredField
        {
            get { return filteredField; }
            set { filteredField = value; }
        }

        public override XElement XElement
        {
            get
            {
                XElement xelement = new XElement("ListTreeNodeClass",
                    new XAttribute("Class", c.Name),
                    new XAttribute("FilteredField", (this.FilteredField != null) ? this.FilteredField.Name : ""),
                    new XElement("Children",
                        from child in this.Childs
                        select child.XElement)
                        );

                return xelement;
            }
        }  
    }
}
