﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class ListTreeNodeAttribute:ListTreeNode
    {
        public const string SORTING_ASC = "Ascending";
        public const string SORTING_DESC = "Descending";
        public const string NO_SORTING = "No sorting";

        public ListTreeNodeAttribute(Field field)
        {
            Field = field;
            generateColumn = true;
            columnName = field.LogicName;
            sortingType = NO_SORTING;
        }

        public ListTreeNodeAttribute(Class c, XElement xelement, ListTreeNodeClass parent):base()
        {
            Field = Repository.Instance.GetClassField(c, xelement.Attribute("Field").Value);
            Parent = parent;
            if (xelement.Attribute("FilterType")!=null)
            {
                FilterType = xelement.Attribute("FilterType").Value;
            }
            if (xelement.Attribute("GenerateColumn") != null)
            {
                generateColumn = (xelement.Attribute("GenerateColumn").Value).Equals("true");
            }
            if (xelement.Attribute("SortingType") != null)
            {
                sortingType = xelement.Attribute("SortingType").Value;
                if (sortingType.Equals(""))
                {
                    sortingType = NO_SORTING;
                }
            }
            else
            {
                sortingType = NO_SORTING;
            }
            if (xelement.Attribute("ColumnName") != null)
            {
                columnName = xelement.Attribute("ColumnName").Value;
                if (columnName.Equals("")) 
                {
                    columnName = field.LogicName;
                }
            }
            else
            {
                columnName = field.LogicName;
            }

            if (xelement.Attribute("ColumnNumber") != null)
            {
                columnNumber = Int32.Parse(xelement.Attribute("ColumnNumber").Value);
            }
        }

        public Field Field
        {
            get { return field; }
            set { field = value; }
        }

        public bool GenerateColumn
        {
            get { return generateColumn; }
            set { generateColumn = value; }
        }

        public string FilterType
        {
            get { return filterType; }
            set { filterType = value; }
        }

        public string ColumnName
        {
            get { return columnName; }
            set { columnName = value; }
        }

        public int ColumnNumber
        {
            get { return columnNumber; }
            set { columnNumber = value; }
        }

        public override XElement XElement
        {
            get
            {
                XElement xelement = new XElement("ListTreeNodeAttribute",
                    new XAttribute("Field", field.Name),
                    new XAttribute("ColumnName", columnName),
                    new XAttribute("ColumnNumber", columnNumber),
                    new XAttribute("SortingType", sortingType),
                    new XAttribute("GenerateColumn", generateColumn),
                    new XAttribute("FilterType", (this.FilterType != null) ? this.FilterType : "")
                        );

                return xelement;
            }
        }

        public string SortingType
        {
            get { return sortingType; }
            set { sortingType = value; }
        }

        private string sortingType;
        
        private string filterType;

        private Field field;

        private bool generateColumn;

        private string columnName = "";

        private int columnNumber = 0;

        public override string ToString()
        {
            return ColumnName;
        }
    }
}
