﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class List:Form
    {
        private ClassInView root;

        private Card card;
        
        private Field locator;

        private ListTreeNodeClass listTreeRoot;

        private View view;

        private bool isAuxiliary;

        public List(string name, string logicName, View view, bool isAuxiliary)
        {
            Name= name;
            LogicName = logicName;
            View = view;
            this.isAuxiliary = isAuxiliary;

        }

        public List(string name, string logicName, Class c, bool isAuxiliary)
        {
            Name = name;
            LogicName = logicName;
            View = null;
            this.isAuxiliary = isAuxiliary;
            ClassInView ciw = new ClassInView();
            ciw.Class = c;
            foreach (Field f in c.Fields)
            {
                ciw.Fields.Add(f);
            }
            Root = ciw;
        }

        public List(XElement xelement)
        {
            Name = xelement.Attribute("Name").Value;
            LogicName = xelement.Attribute("LogicName").Value;
            IsAuxiliary = xelement.Attribute("IsAux").Value.Equals("true");
            
            ListTreeRoot = new ListTreeNodeClass(xelement.Element("Root").Element("ListTreeNodeClass"), null);
            if (xelement.Attribute("Card") != null)
            {
                Card = Repository.Instance.GetCard(xelement.Attribute("Card").Value);
            }
            
            if (xelement.Attribute("Folder") != null)
            {
                if (xelement.Attribute("Folder").Value != "")
                {
                    this.Folder = Repository.Instance.GetFolder(xelement.Attribute("Folder").Value);
                }
            }

            if (xelement.Attribute("Locator") != null)
            {
                if (xelement.Attribute("Locator").Value != "")
                {
                    this.Locator = Repository.Instance.GetClassField(listTreeRoot.Class, xelement.Attribute("Locator").Value.ToString());
                }
            }

        }

        public ListTreeNodeClass CreateDefaultListTree()
        {
            return CreateListTree(view.Classes[0].Class);
        }
        
        public ListTreeNodeClass CreateListTree()
        {
            if (Root != null)
            {
                return CreateListTree(Root.Class);
            }
            else
            {
                return CreateDefaultListTree();
            }
        }

        public ListTreeNodeClass CreateListTree(Class c)
        {
            List<Relation> relations = new List<Relation>();
            if (view != null)
            {
                foreach (Relation r in view.Relations)
                {
                    relations.Add(r);
                }
            }
            List<Class> classes = new List<Class>();
            if (view != null)
            {
                foreach (ClassInView ciw in view.Classes)
                {
                    classes.Add(ciw.Class);
                }
            }
            classes.Remove(c);
            ListTreeNodeClass rootNode = new ListTreeNodeClass();
            rootNode.Class = c;
            FindChilds(rootNode, relations, classes);
            return rootNode;
        }

        private void FindChilds(ListTreeNodeClass n, List<Relation> relations, List<Class> classes)
        {
            
            foreach (Relation r in Repository.Instance.Relations)
            {
                if (classes.Count > 0)
                {
                    foreach (Class c in classes)
                    {
                        if ((relations.Contains(r))&&(r.isRelated(c,n.Class)))
                        {
                            relations.Remove(r);
                            //classesInView.Remove(c);
                            ListTreeNodeClass newNode = new ListTreeNodeClass();
                            newNode.Class = c;
                            FindChilds(newNode, relations,classes);
                            newNode.Parent = n;
                            n.Childs.Add(newNode);
                        }
                        if (classes.Count == 0) break;
                    }
                }
                if (relations.Count == 0) break;
            }
                
                
               

            foreach (Field f in n.Class.Fields) 
            {
                ListTreeNodeAttribute attributeNode = new ListTreeNodeAttribute(f);
                attributeNode.Parent = n;
                n.Childs.Add(attributeNode);
            }
        }
        
        public ClassInView Root
        {
            get { return root; }
            set { root = value; }
        }

        public Card Card
        {
            get { return card; }
            set
            {
                if ((value == null)||(ListTreeRoot.Class.Equals(((Card)value).Class)))
                {
                    card = value;
                }
                else
                {
                    throw new Exception();

                }
            }
        }

        public Field Locator
        {
            get { return locator; }
            set { locator = value; }
        }

        public ListTreeNodeClass ListTreeRoot
        {
            get {
                if (listTreeRoot == null)
                {
                    listTreeRoot = CreateListTree();
                }
                
                
                return listTreeRoot; }
            set { listTreeRoot = value; }
        }

        public View View
        {
            get { return view; }
            set { view = value; }
        }

        public bool IsAuxiliary
        {
            get { return isAuxiliary; }
            set { isAuxiliary = value; }
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("List",
                    new XAttribute("Name", this.Name),
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("Card", (this.Card != null) ? this.Card.Name : ""),
                    new XAttribute("Locator", (this.Locator != null) ? this.Locator.Name : ""),
                    new XElement("Root", this.ListTreeRoot.XElement),
                    new XAttribute("IsAux", this.IsAuxiliary),
                    new XAttribute("Folder", this.Folder == null ? "" : this.Folder.Path),
                    new XAttribute("View", (this.View != null) ? this.View.LogicName : ""));

                return xelement;
            }
        }  

    }
}
