﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class CardTab
    {
        private string logicName;
        
        private System.Collections.Generic.List<CardField> fields;
        
        public CardTab(string logicName)
        {
            LogicName = logicName;
            fields = new List<CardField>();
        }

        public CardTab(Class c, XElement xelement)
        {
            LogicName = xelement.Attribute("LogicName").Value;
            fields = new List<CardField>();
            foreach (XElement cfs in xelement.Element("Fields").Elements("CardFieldSimple"))
            {
                fields.Add( new CardFieldSimple(c, cfs));
            }
            foreach (XElement cfs in xelement.Element("Fields").Elements("CardFieldRelation"))
            {
                fields.Add(new CardFieldRelation(c, cfs));
            }
            foreach (XElement cfs in xelement.Element("Fields").Elements("CardFieldAuxList"))
            {
                fields.Add(new CardFieldAuxList(c, cfs));
            }

        }
        
        public string LogicName
        {
            get { return logicName; }
            set { logicName = value; }
        }

        internal System.Collections.Generic.List<CardField> Fields
        {
            get { return fields; }
            set { fields = value; }
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("Tab",
                    new XAttribute("LogicName", this.LogicName),
                    new XElement("Fields",
                        from field in this.Fields
                        select field.XElement));

                return xelement;
            }
        }     


    }
}
