﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class CardFieldRelation:CardField
    {
        public CardFieldRelation(string logicName, Relation relation, Field field)
        {
            Relation = relation;
            LogicName = logicName;
            this.field = field;
        }

        public CardFieldRelation(Class c, XElement xelement)
        {
            LogicName = xelement.Attribute("LogicName").Value;
            relation = Repository.Instance.GetRelation(Repository.Instance.GetClass(xelement.Attribute("Relation").Value), c);
            field = Repository.Instance.GetClassField(relation.MasterClass, xelement.Attribute("Field").Value);
        }

        private Field field;
        
        private Relation relation;

        public Field Field
        {
            get { return field; }
            set { field = value; }
        }
        
        internal Relation Relation
        {
            get { return relation; }
            set { relation = value; }
        }
        
        public Class RelatedClass
        {
            get 
            {
                return Relation.MasterClass;
            }
        }
        
        public override String Name
        {
            get { return RelatedClass.Name; }
        }

        public override XElement XElement
        {
            get
            {
                XElement xelement = new XElement("CardFieldRelation",
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("Field", this.Field.Name),
                    new XAttribute("Relation", this.RelatedClass.Name));

                return xelement;
            }
        }     


    }
}
