﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository
{
    public class Connection:BaseItem
    {
        private Class sClass;

        public Class SClass
        {
            get { return sClass; }
            set { sClass = value; }
        }
        private string source;

        public string Source
        {
            get { return source; }
            set { source = value; }
        }
        private string target;

        public string Target
        {
            get { return target; }
            set { target = value; }
        }
        private string sourceStateName;

        public string SourceStateName
        {
            get { return sourceStateName; }
            set { sourceStateName = value; }
        }
        private string targetStateName;

        public string TargetStateName
        {
            get { return targetStateName; }
            set { targetStateName = value; }
        }
        private string condition;

        public string Condition
        {
            get { return condition; }
            set { condition = value; }
        }
        public Connection(Class sClass, 
            string source, string target,
            string sourceStateName, string targetStateName, 
            string condition,
            ParseXMIDocument.ParseXMI.DiagramElement sourceType, ParseXMIDocument.ParseXMI.DiagramElement targetType)
        {
            SClass = sClass;
            Source = source;
            Target = target;
            SourceStateName = sourceStateName;
            TargetStateName = targetStateName;
            Condition = condition;
            SourceType = sourceType;
            TargetType = targetType;
        }

        private ParseXMIDocument.ParseXMI.DiagramElement sourceType;

        public ParseXMIDocument.ParseXMI.DiagramElement SourceType
        {
            get { return sourceType; }
            set { sourceType = value; }
        }
        private ParseXMIDocument.ParseXMI.DiagramElement targetType;

        public ParseXMIDocument.ParseXMI.DiagramElement TargetType
        {
            get { return targetType; }
            set { targetType = value; }

        }
        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("connection",
                    new XAttribute("className", sClass.Name),
                    new XAttribute("source", Source),
                    new XAttribute("target", Target),
                    new XAttribute("sourceStateName", SourceStateName),
                    new XAttribute("targetStateName", TargetStateName),
                    new XAttribute("sourceType", sourceType),
                    new XAttribute("targetType", targetType),
                    new XAttribute("condition", Condition)
                    );
                return xelement;
            }
        }
    }
}
