﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository
{
    public class ClassInView
    {
        private Class c;
       
        private List<Field> fields;

        public ClassInView()
        {
            fields = new List<Field>();    
        
        }

        public ClassInView(XElement xelement)
        {
            c = Repository.Instance.GetClass(xelement.Attribute("Class").Value);
            fields = new List<Field>();
            foreach (XElement f in xelement.Element("Fields").Elements("Field"))
            {
                fields.Add(Repository.Instance.GetClassField(c,f.Value));
            }
        }

        public Class Class
        {
            get { return c; }
            set { c = value; }
        }

        public List<Field> Fields
        {
            get { return fields; }
            set { fields = value; }
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("ClassInView",
                    new XAttribute("Class", this.Class.Name),
                    new XElement("Fields", from field in this.Fields select new XElement("Field", field.Name))
                    );

                return xelement;
            }
        }
    }
}
