﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Data.OleDb;
using FormGenerator.Repository;

namespace FormGenerator.Generate
{
    public class DatabaseGenerator
    {
        public void Generate(string path)
        {
            string fromPath = Application.StartupPath + "\\Templates\\EmptyDatabase.mdb";
            string toPath = path;

            File.Copy(fromPath, toPath, true);

            OleDbConnection oleDbConnection = new OleDbConnection("provider = microsoft.jet.oledb.4.0;data source = "+path+";");
            oleDbConnection.Open();

            foreach (Class c in Repository.Repository.Instance.Classes)
            {
                string fields;
                fields = "Id INT";
                foreach (Field f in c.Fields)
                {
                    fields += "," + getSqlFieldName(f.Name) + " " + GetSQLType(f.Type);    

                }

                foreach (Class r in Repository.Repository.Instance.GetMasterClasses(c))
                {
                    fields += "," + getSqlTableName(r.Name)+"Id "+"Int"; 
                }


                OleDbCommand oleDbCommand = new OleDbCommand("CREATE TABLE "+getSqlTableName(c.Name)+"("+fields+");", oleDbConnection);
                oleDbCommand.ExecuteNonQuery();
            }
            foreach (FormGenerator.Repository.Enum e in Repository.Repository.Instance.Enums)
            {
                foreach (int key in e.Values.Keys)
                {
                    OleDbCommand oleDbCommand = new OleDbCommand("INSERT INTO " + getSqlTableName(e.Class.Name) +" (Id, fValue) VALUES ("+key.ToString()+",'"+e.Values[key]  + "')", oleDbConnection);
                    oleDbCommand.ExecuteNonQuery();
                }
            }


        }


        public static string GetSQLType(string type)
        {
            if (type.Equals("Int32"))
            {
                return "Int";
            }
            if (type.Equals("Boolean"))
            {
                return "Number";
            }
            return type;
        }

        public static string getSqlFieldName(string fieldName)
        {
            return ("f" + fieldName);
        }
        public static string getSqlTableName(string className)
        {
            return ("c" + className);
        }
    }
}
