﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.View.View;

namespace FormGenerator.View
{
    public partial class ViewEditor : Form
    {
        public ViewEditor()
        {
            InitializeComponent();
            InitializeViewList();
        }
        private void InitializeViewList()
        {
            ViewList.Groups.Clear();
            ViewList.Items.Clear();

            ListViewGroup viewListViewGroup = new ListViewGroup("Views");

            ViewList.Groups.Add(viewListViewGroup);
            if (Repository.Repository.Instance.Cards.Count > 0)
            {

                foreach (Repository.View view in Repository.Repository.Instance.Views)
                {

                    ViewListViewItem viewItem = new ViewListViewItem();
                    viewItem.Text = view.LogicName;
                    viewItem.Group = viewListViewGroup;
                    viewItem.View = view;
                    ViewList.Items.Add(viewItem);
                    
                }
            }
        }

        private void ViewList_MouseClick(object sender, MouseEventArgs e)
        {
            ListViewItem lviClicked = ViewList.GetItemAt(e.X, e.Y);
            ViewList.SelectedItems.Clear();
            lviClicked.Selected = true;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            
            ViewProperties frm = new ViewProperties(null);
            frm.Show();
        }

        private void ViewList_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyValue == 46)
            {
                foreach (ListViewItem selectedItem in ViewList.SelectedItems)
                {
                    Repository.Repository.Instance.DeleteView(((ViewListViewItem)selectedItem).View);
                }



            }
        }

        private void ViewList_SelectedIndexChanged(object sender, EventArgs e)
        {
           
        }

        private void ViewList_DoubleClick(object sender, EventArgs e)
        {
            if (ViewList.SelectedItems.Count > 0)
            {
                ViewProperties frm = new ViewProperties(((ViewListViewItem)(ViewList.SelectedItems[0])).View);
                frm.Show();
            }
        }
    }
}
