﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;
using System.Drawing;

namespace FormGenerator.View
{
    public class ViewAttributeNode:TreeNode
    {
        public ViewAttributeNode(ListTreeNodeAttribute node)
        {
            Node = node;
            Text = node.Field.LogicName;
        }

        public ListTreeNodeAttribute Node
        {
            get { return node; }
            set { node = value; }
        }

        public void MakeFilter()
        {
            if (node.IsFilter)
            {
                NodeFont = new Font(FontFamily.GenericSerif, 8, FontStyle.Bold);
            }
            else
            {
                NodeFont = new Font(FontFamily.GenericSerif, 8, FontStyle.Regular);
            }
        }
        
        private ListTreeNodeAttribute node;


        public override string ToString()
        {
            return node.ColumnName + GetSortingSymbol();
        }

        private string GetSortingSymbol()
        {
            switch (node.SortingType)
            {
                case ListTreeNodeAttribute.SORTING_ASC: return " ↑";
                case ListTreeNodeAttribute.SORTING_DESC: return " ↓";
            }
            return "";
        }
    }
}
