﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class FolderParameters : FormGenerator.View.BaseForm
    {
        private Folder folder;

        public FolderParameters(Folder folder)
        {
            InitializeComponent();
            
            if (folder != null)
            {
                this.folder = folder;
                
                textBoxName.Text = folder.Name;
                textBoxPath.Text = folder.Path;
            }
            
            
        }
        protected override void SaveData()
        {
            if (folder == null)
            {
                folder = new Folder(textBoxName.Text, textBoxPath.Text);
                Repository.Repository.Instance.Folders.Add(folder);
            }
            else
            {
                folder.Name = textBoxName.Text;
                folder.Path = textBoxPath.Text;
            }
           
            base.SaveData();
        }
    }
}
