﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository.Forms;
using FormGenerator.Repository;

namespace FormGenerator.View
{
    public partial class CardFieldSimpleProperties : System.Windows.Forms.Form
    {
        private CardFieldSimple field; 

        public CardFieldSimpleProperties(CardField cardField)
        {
            InitializeComponent();
            field = (CardFieldSimple)cardField;
            logicNameTextBox.Text = field.LogicName;
            nameTextBox.Text = field.Field.Name;


            if (field.Field.Type.Equals(Field.STRING))
            {
                comboBoxAdditional.Items.Add("NO");
                comboBoxAdditional.Items.Add("Multiline");
                if (field.Additional != null)
                {
                    if (field.Additional.Equals(CardFieldSimple.MULTILINE))
                    {
                        comboBoxAdditional.SelectedIndex = 1;
                    }
                    else
                    {
                        comboBoxAdditional.SelectedIndex = 0;

                    }
                }
                else
                {
                    comboBoxAdditional.SelectedIndex = 0;

                }
            }
            else
            {
                comboBoxAdditional.Enabled = false;
            }

        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void saveButton_Click(object sender, EventArgs e)
        {
            field.LogicName = logicNameTextBox.Text;
            if (field.Field.Type.Equals(Field.STRING))
            {
                if (!comboBoxAdditional.SelectedItem.Equals("NO"))
                {
                    field.Additional = CardFieldSimple.MULTILINE;
                }
                else
                {
                    field.Additional = null;
                }
            }
            this.Close();
        }

        private void CardFieldSimpleProperties_Load(object sender, EventArgs e)
        {

        }
    }
}
