﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseXMIDocument
{
    public class MultiDict<TKey, TValue>
    {
        private readonly Dictionary<TKey, List<TValue>> data = new Dictionary<TKey, List<TValue>>();

        public void Add(TKey key, TValue value)
        {
            List<TValue> values;
            if (!data.TryGetValue(key, out values))
            {
                values = new List<TValue>();
                data.Add(key, values);
            }
            values.Add(value);
        }
        public bool TryGetValue(TKey key, out List<TValue> values)
        {
            return data.TryGetValue(key, out values);
        }
        public bool ContainsKey(TKey key)
        {
            return data.ContainsKey(key);
        }
        /*
        public IEnumerable<TKey> Keys
        {
            get { return data.Keys; }
        }
        */
        public bool Contains(KeyValuePair<TKey, TValue> item)
        {
            List<TValue> list;
            if (!data.TryGetValue(item.Key, out list))
            {
                return false;
            }
            else
            {
                return list.Contains(item.Value);
            }
        }
        public List<TValue> this[TKey key]
        {
            get
            {
                if (data.ContainsKey(key))
                    return data[key];

                return new List<TValue>();
            }
            set
            {
                data[key] = value;
            }
        }
        public int Count
        {
            get
            {
                int count = 0;

                Dictionary<TKey, List<TValue>>.Enumerator enumerator = data.GetEnumerator();
                while (enumerator.MoveNext())
                {

                    KeyValuePair<TKey, List<TValue>> pair = enumerator.Current;
                    count += pair.Value.Count;
                }
                return count;
            }
        }
        public bool Remove(KeyValuePair<TKey, TValue> item)
        {
            List<TValue> list;
            if (data.TryGetValue(item.Key, out list))
            {
                return list.Remove(item.Value);
            }
            else
            {
                return false;
            }
        }
        public IEnumerator<KeyValuePair<TKey, TValue>> GetEnumerator()
        {
            Dictionary<TKey, List<TValue>>.Enumerator enumerateKeys = data.GetEnumerator();
            while (enumerateKeys.MoveNext())
            {
                foreach (TValue val in enumerateKeys.Current.Value)
                {
                    KeyValuePair<TKey, TValue> pair = new KeyValuePair<TKey, TValue>(
                       enumerateKeys.Current.Key, val);
                    yield return pair;
                }
            }
        }
        /*
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }*/
        public List<TKey> Keys
        {
            get { return new List<TKey>(data.Keys); }
            //return data.Keys;
        }
        public IEnumerable<List<TValue>> Values
        {
            get { return data.Values; }
        }
    }
}

