﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace ParseXMIDocument
{
    public class InformationFlow : IDiagramObject
    {
        private string _Name;
        public string Name
        {
            get
            {
                return _Name;
            }
            set
            {
                _Name = value;
            }
        }
        public string InformationSource { get; set; }
        public string InformationTarget { get; set; }

        private ParseXMIDocument.ParseXMI.DiagramElement sourceType;

        public ParseXMIDocument.ParseXMI.DiagramElement SourceType
        {
            get { return sourceType; }
            set { sourceType = value; }
        }
        private ParseXMIDocument.ParseXMI.DiagramElement targetType;

        public ParseXMIDocument.ParseXMI.DiagramElement TargetType
        {
            get { return targetType; }
            set { targetType = value; }
        }
        public InformationFlow(string name, string informationSource, string informationTarget,
            ParseXMIDocument.ParseXMI.DiagramElement sourceType, ParseXMIDocument.ParseXMI.DiagramElement targetType)
        {
            Name = name;
            InformationSource = informationSource;
            InformationTarget = informationTarget;
            SourceType = sourceType;
            TargetType = targetType;
        }

        public XElement Xelement
        {
            get 
            {
                XElement xelement = new XElement("informationFlow",
                    new XAttribute("name", Name),
                    new XAttribute("source", InformationSource),
                    new XAttribute("target", InformationTarget),
                    new XAttribute("sourceType", sourceType),
                    new XAttribute("targetType", targetType)
                    );
                return xelement;
            }
        }
    }
}
