﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ParseXMIDocument
{
    public class DecisionNode : IDiagramObject
    {
        public enum GateType
        {
            Exclusive,
            Other
        };
        private GateType type;

        public GateType Type
        {
            get { return type; }
            set { type = value; }
        } 
        private string _Name;
        public string Name
        {
            get
            {
                return _Name;
            }
            set
            {
                _Name = value;
            }
        }
        public List<string> Incoming { get; set; }
        public List<string> Outgoing { get; set; }
        public DecisionNode(string name, List<string> incoming, List<string> outgoing, GateType type)
        {
            Name = name;
            Incoming = incoming;
            Outgoing = outgoing;
            Type = type;
        }
    }
}
