﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FormGenerator.Repository;
using System.Xml.Linq;
using FormGenerator.Repository.Forms;

namespace FormGenerator.Forms
{
    public class ManyToManyRelationship:Form
    {
        private Class intermediateClass;
        private Relation partyRelation;
        private Relation memberRelation;
        private Field partyClassField;
        private Field memberClassField;

        public ManyToManyRelationship(string name, string logicName)
        {
            this.LogicName = logicName;
            this.Name = name;
        }

        public ManyToManyRelationship(XElement xelement)
        {
            Name = xelement.Attribute("Name").Value;
            LogicName = xelement.Attribute("LogicName").Value;
           

            intermediateClass = Repository.Repository.Instance.GetClass(xelement.Attribute("IntermediateClass").Value);
            
            partyRelation = Repository.Repository.Instance.GetRelation(xelement.Attribute("PartyClass").Value, xelement.Attribute("IntermediateClass").Value);
            memberRelation = Repository.Repository.Instance.GetRelation(xelement.Attribute("MemberClass").Value, xelement.Attribute("IntermediateClass").Value);

            partyClassField = Repository.Repository.Instance.GetClassField(xelement.Attribute("PartyClass").Value, xelement.Attribute("PartyClassField").Value);
            memberClassField = Repository.Repository.Instance.GetClassField(xelement.Attribute("MemberClass").Value, xelement.Attribute("MemberClassField").Value);

            if (xelement.Attribute("Folder") != null)
            {
                if (xelement.Attribute("Folder").Value != "")
                {
                    this.Folder = Repository.Repository.Instance.GetFolder(xelement.Attribute("Folder").Value);
                }
            }
        
        }

        public Class IntermediateClass
        {
            get { return intermediateClass; }
            set { intermediateClass = value; }
        }

        public Relation PartyRelation
        {
            get { return partyRelation; }
            set { partyRelation = value; }
        }

        public Relation MemberRelation
        {
            get { return memberRelation; }
            set { memberRelation = value; }
        }

        public Field PartyClassField
        {
            get { return partyClassField; }
            set { partyClassField = value; }
        }

        public Field MemberClassField
        {
            get { return memberClassField; }
            set { memberClassField = value; }
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("ManyToManyRelationship",
                    new XAttribute("Name", this.Name),
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("IntermediateClass", this.intermediateClass.Name),
                    new XAttribute("PartyClass", this.partyRelation.MasterClass.Name),
                    new XAttribute("MemberClass", this.memberRelation.MasterClass.Name),
                    new XAttribute("PartyClassField", this.partyClassField.Name),
                    new XAttribute("Folder", this.Folder == null ? "" : this.Folder.Path),
                    new XAttribute("MemberClassField", this.memberClassField.Name)

                    );

                return xelement;
            }


        }     

    }
}
