﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class CardFieldAuxList : CardField
    {
        private List list;
        private Class slaveClass;   
     
        public CardFieldAuxList(List list, Class slaveClass)
        {
            List = list;
            SlaveClass = slaveClass;
        }

        public CardFieldAuxList(Class c, XElement xelement)
        {
            LogicName = xelement.Attribute("LogicName").Value;
            if (xelement.Attribute("List") != null)
            {
                if (xelement.Attribute("List").Value != "")
                {
                    list = Repository.Instance.GetList(xelement.Attribute("List").Value);
                }
                else
                {
                    list = null;
                }
                
            }
            slaveClass = Repository.Instance.GetClass(xelement.Attribute("slaveClass").Value);
        }

        public List List
        {
            get { return list; }
            set 
            { 
                list = value;
                if (list != null)
                {
                    LogicName = list.Name;
                }
            }
        }

        public Class SlaveClass
        {
            get { return slaveClass; }
            set { 
                slaveClass = value;
                LogicName = slaveClass.LogicName;
            }
        }

        public override String Name
        {
            get
            {
                if (list == null)
                {
                    return null;
                }
                else 
                {
                    return List.Name; 
                }
            }
        }

        public override XElement XElement
        {
            get
            {
                XElement xelement = new XElement("CardFieldAuxList",
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("List", this.List!=null?this.List.Name:""),
                    new XAttribute("slaveClass", this.SlaveClass.Name));

                return xelement;
            }
        }     

    }
}
