﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using FormGenerator.Forms;
using FormGenerator.Repository.Forms;

namespace FormGenerator.Generate
{
    public  class MenuGenerator : Generator
    {
        public  void Generate()
        {
            //move to copy
            StringBuilder ItemsSB = new StringBuilder();

            foreach (Folder folder in Repository.Repository.Instance.Folders)
            {

                ItemsSB.AppendFormat("            BarSubItem barSubItem{0} = new BarSubItem();\n", folder.Path);
                ItemsSB.AppendFormat("            barSubItem{0}.Caption = \"{1}\";\n", folder.Path, folder.Name);
                ItemsSB.AppendFormat("            mainBar.AddItem(barSubItem{0});\n", folder.Path);
                foreach (List list in Repository.Repository.Instance.GetNotAuxListsFromFolder(folder))
                {
                    ItemsSB.AppendFormat("            AddSubButtonItem(barSubItem{2}, \"{0}\", \"{1}\",   typeof (GUI.{0}));\n", list.Name, list.LogicName, folder.Path);
                }
                foreach (Tree tree in Repository.Repository.Instance.GetTreesFromFolder(folder))
                {
                    ItemsSB.AppendFormat("            AddSubButtonItem(barSubItem{2}, \"{0}\", \"{1}\",   typeof (GUI.{0}));\n", tree.Name, tree.LogicName, folder.Path);
                }

                foreach (ManyToManyRelationship relation in Repository.Repository.Instance.GetRelationshipsFromFolder(folder))
                {
                    ItemsSB.AppendFormat("            AddSubButtonItem(barSubItem{2}, \"{0}\", \"{1}\",   typeof (GUI.{0}));\n", relation.Name, relation.LogicName, folder.Path);
                }

            }

            string fromPath = Application.StartupPath + "\\Templates\\MenuConstructor.cs";
            string toPath = System.Configuration.ConfigurationSettings.AppSettings["FormsOutputPath"] + "\\..\\MenuConstructor.cs";

            File.Copy(fromPath, toPath, true);

            ReplaceInFile(toPath, "ZZMenuItemsZZ", ItemsSB.ToString());
        }
    }
}
