﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FormGenerator.Repository.Forms;
using System.Windows.Forms;
using System.IO;
using FormGenerator.Repository;

namespace FormGenerator.Generate
{
    class ListGenerator:Generator
    {
        private String fieldsPrivateDeclaration = "";
        private String filtersAddDeclaration = "";
        private String fieldsNewDeclaration = "";
        private String pnlFiltersDeclaration = "";
        private String pnlSearchesDeclaration = "";
        private String controlsProperties = "";
        private String columnList = "";

        private String selectQueryPart = "";
        private String fromQueryPart = "";
        private String bracketsQueryPart = "";

        private int filterPositionX = 6;

        private FormGenerator.Repository.Forms.List list;
       

        public ListGenerator(FormGenerator.Repository.Forms.List list)
        {
            this.list = list;
           
        }

        public void Generate( string path)
        {
            //move to copy

            string fromPath = Application.StartupPath + "\\Templates\\"+((this.list is Tree)?"Tree":"List")+".cs";
            string toPath = path + "\\" + list.Name + ".cs";
            Directory.CreateDirectory(path);
            File.Copy(fromPath, toPath, true);

            //move to generate

            ReplaceInFile(toPath, "ZZfnZZ", list.Name);
            if (!list.IsAuxiliary)
            {
                ReplaceInFile(toPath, "ZZListClassZZ", "CommonList");
                ReplaceInFile(toPath, "ZZCaptionPropertyZZ", "    public override string Caption \n{ get{ return \"ZZCaptionZZ\";}}");
                ReplaceInFile(toPath, "ZZBarManagerZZ", "    ((System.ComponentModel.ISupportInitialize)(this.barManager)).BeginInit();");
                ReplaceInFile(toPath, "ZZAutoScaleZZ", "this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);");
                ReplaceInFile(toPath, "ZZBarManager2ZZ", "((System.ComponentModel.ISupportInitialize)(this.barManager)).EndInit();");
                ReplaceInFile(toPath, "ZZLinkedColumnZZ", "");

            }
            else
            {
                ReplaceInFile(toPath, "ZZListClassZZ", "InplaceListCtrl");
                ReplaceInFile(toPath, "ZZCaptionPropertyZZ", "");
                ReplaceInFile(toPath, "ZZBarManagerZZ", "");
                ReplaceInFile(toPath, "ZZAutoScaleZZ", "");
                ReplaceInFile(toPath, "ZZBarManager2ZZ","");
                ReplaceInFile(toPath, "ZZLinkedColumnZZ", "	");
            }   

            ReplaceInFile(toPath, "ZZpnZZ", list.ListTreeRoot.Class.Name);
            selectQueryPart =  "  \"SELECT  \" +  \n";
            fromQueryPart = DatabaseGenerator.getSqlTableName( list.ListTreeRoot.Class.Name)+ "\" +  \n";
            CreateFiltersDeclaration(list.ListTreeRoot);
          
            if (list.IsAuxiliary&& list.Card!=null)
            {
                foreach (CardTab t in list.Card.Tabs)
                {
                    foreach (CardField f in t.Fields)
                    {
                        if (f is CardFieldSimple)
                        {
                             selectQueryPart += GetSelectQueryPartStringForAuxList(list.Card.Class, (CardFieldSimple)f);
                        }
                        if (f is CardFieldRelation)
                        {
                            selectQueryPart += GetSelectQueryPartStringForAuxList(list.Card.Class, (CardFieldRelation)f);
                        }
                    }
                }

            }

            selectQueryPart += "\"" + DatabaseGenerator.getSqlTableName(list.ListTreeRoot.Class.Name) + ".Id\" +\n";


            if (list.Locator != null)
            {
                controlsProperties += GetLocatorProperties(list.Locator);
                fieldsPrivateDeclaration += ("private Locator locator" + list.Locator.Name + ";\n");
                fieldsPrivateDeclaration += ("private System.Windows.Forms.Label label" + list.Locator.Name + ";\n");
                fieldsNewDeclaration += ("this.locator" + list.Locator.Name + " = new Tercom.RealIT.CommonGUI.Locator();\n");
                fieldsNewDeclaration += ("this.label" + list.Locator.Name + " = new System.Windows.Forms.Label();\n");
                pnlSearchesDeclaration += ("this.pnlSearches.Controls.Add(this.label" + list.Locator.Name + ");\n");
                pnlSearchesDeclaration += ("this.pnlSearches.Controls.Add(this.locator" + list.Locator.Name + ");\n");


            }
            
            ReplaceInFile(toPath, "ZZFieldsPrivateZZ", fieldsPrivateDeclaration);
            ReplaceInFile(toPath, "ZZFiltersAddZZ", filtersAddDeclaration);
            ReplaceInFile(toPath, "ZZFieldsNewZZ", fieldsNewDeclaration);
            ReplaceInFile(toPath, "ZZFiltersPanelZZ", pnlFiltersDeclaration);
            ReplaceInFile(toPath, "ZZControlsDescrZZ", controlsProperties);
           
            ReplaceInFile(toPath, "ZZGridColsZZ", columnList);
            ReplaceInFile(toPath, "ZZSearchesPanelZZ", pnlSearchesDeclaration);
            
            ReplaceInFile(toPath, "ZZqueryZZ", selectQueryPart+"\" FROM "+bracketsQueryPart+fromQueryPart +"\" {where}\";\n"  );
            ReplaceInFile(toPath, "ZZCaptionZZ", list.LogicName);

            //redirecting to card is disabled for aux lists due to strange bug with run-time
            if ((list.Card == null))
            {
                ReplaceInFile(toPath, "ZZEnableButtonsZZ", " btnEdit.Enabled = false; btnNew.Enabled = false; ");

                ReplaceInFile(toPath, "ZZCreateCardZZ", "");

            }
            else
            {
                ReplaceInFile(toPath, "ZZEnableButtonsZZ", "");
                ReplaceInFile(toPath, "ZZCreateCardZZ", "protected override CommonCard CreateCard(bool forInsert) \n  { \n   return new ZZcnZZ(); \n  }\n");

            }

            if ((list.Card != null))
            {
                ReplaceInFile(toPath, "ZZcnZZ", list.Card.Name);
            }

        }

        private String GetSelectQueryPartString(ListTreeNodeAttribute node)
        {
                StringBuilder sb = new StringBuilder();
                String cn = ((ListTreeNodeClass)(node.Parent)).Class.Name;
                String fn = node.Field.Name;
                sb.AppendFormat("    \"{0}.{1} AS {2}{3},  \" +\n", DatabaseGenerator.getSqlTableName(cn), DatabaseGenerator.getSqlFieldName(fn),cn,fn);
                return sb.ToString();
        }

        private String GetSelectQueryPartStringForAuxList(Class c, CardFieldSimple f)
        {
            StringBuilder sb = new StringBuilder();
            String cn = c.Name;
            String fn = f.Name;
            sb.AppendFormat("    \"{0}.{1} AS {2},  \" +\n", DatabaseGenerator.getSqlTableName(cn), DatabaseGenerator.getSqlFieldName(fn), DatabaseGenerator.getSqlFieldName(fn));
            return sb.ToString();
        }

        private String GetSelectQueryPartStringForAuxList(Class c, CardFieldRelation f)
        {
            StringBuilder sb = new StringBuilder();
            String cn = c.Name;
            String rcn = f.RelatedClass.Name;
            sb.AppendFormat("    \"{0}.{1}Id AS {1}Id,  \" +\n", DatabaseGenerator.getSqlTableName(cn), DatabaseGenerator.getSqlTableName(rcn));
            return sb.ToString();
        }

        private String GetFromQueryPartString(ListTreeNodeClass node)
        {
            StringBuilder sb = new StringBuilder();
            String pn = ((ListTreeNodeClass)(node.Parent)).Class.Name;
            String cn = node.Class.Name;
            sb.AppendFormat("  \" LEFT JOIN {1} ON {0}.{1}Id  = {1}.Id )\"+\n", DatabaseGenerator.getSqlTableName( pn), DatabaseGenerator.getSqlTableName( cn));
            return sb.ToString();
        }


        private void CreateFiltersDeclaration(ListTreeNodeClass root)
        {
            foreach (ListTreeNode node in root.Childs)
            {
                if (node.IsFilter)
                {
                    fieldsPrivateDeclaration += GetFieldPrivateDeclaration(node);
                    filtersAddDeclaration += GetFilterAddDeclaration(node);
                    fieldsNewDeclaration += GetFilterNewDeclaration(node);
                    controlsProperties += GetFilterProperties(node);
                    pnlFiltersDeclaration += GetPnlFilterDeclaration(node);
                }
                if (node is ListTreeNodeAttribute)
                {
                    if (((ListTreeNodeAttribute)node).GenerateColumn)
                    {
                        fieldsPrivateDeclaration += GetColumnPrivateDeclaration((ListTreeNodeAttribute)node);
                        fieldsNewDeclaration += GetColumnNewDeclaration((ListTreeNodeAttribute)node);
                        controlsProperties += GetColumnProperties((ListTreeNodeAttribute)node);

                        if (!columnList.Equals("")) columnList += " ,";
                        columnList += "col" + ((ListTreeNodeClass)(node.Parent)).Class.Name + ((ListTreeNodeAttribute)node).Field.Name;
                        selectQueryPart += GetSelectQueryPartString((ListTreeNodeAttribute)node);
                    }
                }
                if (node is ListTreeNodeClass)
                {   
                    if (!node.Equals(list.ListTreeRoot))
                    {
                        fromQueryPart+=GetFromQueryPartString((ListTreeNodeClass)node);
                        bracketsQueryPart += "(";
                    }
                    CreateFiltersDeclaration((ListTreeNodeClass)node);
                    
                }



            }
            
            


        }
        
        private static String GetFieldPrivateDeclaration(ListTreeNode node)
        {
            if (node is ListTreeNodeAttribute)
            {
                switch (((ListTreeNodeAttribute)node).Field.Type)
                {
                    //
                }
                return "";
            }
            if (node is ListTreeNodeClass)
            {
                return ("		private System.Windows.Forms.Label label" + ((ListTreeNodeClass)node).Class.Name + "; \n" +
                        "       private DevExpress.XtraEditors.LookUpEdit lookUpEdit" + ((ListTreeNodeClass)node).Class.Name + ";\n");
            }
            return "";
        }
        private static String GetColumnPrivateDeclaration(ListTreeNodeAttribute node)
        {
            return "private GridColumn col"+((ListTreeNodeClass)(node.Parent)).Class.Name+node.Field.Name+"; \n";
        }

        private static String GetFilterAddDeclaration(ListTreeNode node)
        {
            if (node is ListTreeNodeAttribute)
            {
                switch (((ListTreeNodeAttribute)node).Field.Type)
                {
                    //
                }
                return "";
            }
            if (node is ListTreeNodeClass)
            {
                StringBuilder sb = new StringBuilder();
                String cn = DatabaseGenerator.getSqlTableName(((ListTreeNodeClass)node).Class.Name);
                String fn = DatabaseGenerator.getSqlFieldName(((ListTreeNodeClass)node).FilteredField.Name);

                sb.AppendFormat("      	LookupFilter filter{0} = new LookupFilter(lookUpEdit{2},\"Id\",\"{1}\",false,\"SELECT Id, {1} FROM \" + \"{0}\" +\"{{where}}\",\"{1}\");\n", cn, fn, ((ListTreeNodeClass)node).Class.Name);
                sb.AppendFormat("      	AddFilter(filter{0},\"{0}.Id\");\n", cn);
                return sb.ToString();
            }
            return "";
        }

        private static String GetFilterNewDeclaration(ListTreeNode node)
        {
            if (node is ListTreeNodeAttribute)
            {
                switch (((ListTreeNodeAttribute)node).Field.Type)
                {
                    //
                }
                return "";
            }
            if (node is ListTreeNodeClass)
            {
                StringBuilder sb = new StringBuilder();
                String cn = ((ListTreeNodeClass)node).Class.Name;
                

                sb.AppendFormat("      	this.label{0} = new System.Windows.Forms.Label();\n",cn);
                sb.AppendFormat("      	this.lookUpEdit{0} = new DevExpress.XtraEditors.LookUpEdit();\n", cn);

                
                
                
                return sb.ToString();
            }
            return "";
        }
        private static String GetColumnNewDeclaration(ListTreeNodeAttribute node)
        {
            
                StringBuilder sb = new StringBuilder();
                String cn = ((ListTreeNodeClass)(node.Parent)).Class.Name + node.Field.Name;
                sb.AppendFormat("      	this.col{0} = new DevExpress.XtraGrid.Columns.GridColumn();\n", cn);
                return sb.ToString();
            
        }
        private static String GetPnlFilterDeclaration(ListTreeNode node)
        {
            if (node is ListTreeNodeAttribute)
            {
                switch (((ListTreeNodeAttribute)node).Field.Type)
                {
                    //
                }
                return "";
            }
            if (node is ListTreeNodeClass)
            {
                StringBuilder sb = new StringBuilder();
                String cn = ((ListTreeNodeClass)node).Class.Name;

                sb.AppendFormat("     this.pnlFilter.Controls.Add(this.label{0});\n", cn);
                sb.AppendFormat("     this.pnlFilter.Controls.Add(this.lookUpEdit{0});\n", cn);
                return sb.ToString();
            }
            return "";
        }

        private String GetFilterProperties(ListTreeNode node)
        {
            if (node is ListTreeNodeAttribute)
            {
                switch (((ListTreeNodeAttribute)node).Field.Type)
                {
                    //
                }
                return "";
            }
            if (node is ListTreeNodeClass)
            {
                StringBuilder sb = new StringBuilder();
                String cn = ((ListTreeNodeClass)node).Class.Name;
                String fn = ((ListTreeNodeClass)node).FilteredField.Name;
                String ln = ((ListTreeNodeClass)node).Class.LogicName;

                sb.AppendFormat(" this.pnlFilter.Controls.Add(this.label{0});\n", cn);

                sb.AppendFormat("     // \n", cn);
                sb.AppendFormat("     // label{0}\n", cn);
                sb.AppendFormat("     // \n", cn);
                sb.AppendFormat("     this.label{0}.AutoSize = true;\n", cn);
                sb.AppendFormat("     this.label{0}.Location = new System.Drawing.Point({1}, {2});\n", cn, filterPositionX, 23);
                sb.AppendFormat("     this.label{0}.Name = \"label{0}\";\n", cn);
                sb.AppendFormat("     this.label{0}.Size = new System.Drawing.Size(85, 13);\n", cn);
                sb.AppendFormat("     this.label{0}.TabIndex = 3;\n", cn);
                sb.AppendFormat("     this.label{0}.Text = \"{1}\";\n", cn, ln);
                sb.AppendFormat("     // \n", cn);      
                sb.AppendFormat("     // lookUpEdit{0}\n", cn);
                sb.AppendFormat("     // \n", cn);
                sb.AppendFormat("     this.lookUpEdit{0}.Location = new System.Drawing.Point({1}, {2});\n", cn,filterPositionX+90,19);
                sb.AppendFormat("     this.lookUpEdit{0}.Name = \"lookUpEdit{0}\";\n", cn);
                sb.AppendFormat("     this.lookUpEdit{0}.Properties.Buttons.AddRange(new DevExpress.XtraEditors.Controls.EditorButton[] {{\n", cn);
                sb.AppendFormat("         new DevExpress.XtraEditors.Controls.EditorButton(DevExpress.XtraEditors.Controls.ButtonPredefines.Combo)}});\n", cn);
                sb.AppendFormat("     this.lookUpEdit{0}.Size = new System.Drawing.Size(219, 23);\n", cn);
                sb.AppendFormat("     this.lookUpEdit{0}.TabIndex = 3;\n", cn);


                filterPositionX += 270;

                return sb.ToString();
            }
            return "";
        }

        private static String GetColumnProperties(ListTreeNodeAttribute node)
        {
            StringBuilder sb = new StringBuilder();
            String cn = ((ListTreeNodeClass)(node.Parent)).Class.Name + node.Field.Name;
            sb.AppendFormat("      	// \n");
            sb.AppendFormat("      	// col{0}\n",cn);
            sb.AppendFormat("      	// \n");
            sb.AppendFormat("      	this.col{0}.Caption = \"{1}\";\n",cn,node.ColumnName);
            sb.AppendFormat("      	this.col{0}.FieldName = \"{0}\";\n", cn);
            sb.AppendFormat("      	this.col{0}.Name = \"col{0}\";\n", cn);
            sb.AppendFormat("      	this.col{0}.Visible = true;\n", cn);
            sb.AppendFormat("      	this.col{0}.VisibleIndex = {1};\n", cn,node.ColumnNumber);
            if (node.SortingType.Equals(ListTreeNodeAttribute.SORTING_ASC))
            {
                sb.AppendFormat("       this.col{0}.SortOrder = DevExpress.Data.ColumnSortOrder.Ascending;",cn);
            }
            if (node.SortingType.Equals(ListTreeNodeAttribute.SORTING_DESC))
            {
                sb.AppendFormat("       this.col{0}.SortOrder = DevExpress.Data.ColumnSortOrder.Descending;",cn);
            }
            
            return sb.ToString();

        }

        

        private String GetLocatorProperties(Field locator)
        {
            StringBuilder sb = new StringBuilder();
            String ln = locator.Name;
            sb.AppendFormat("      	// \n");
            sb.AppendFormat("      	// locator{0}\n",ln);
            sb.AppendFormat("      	// \n");
            sb.AppendFormat("      	this.locator{0}.DataField = \"{1}\";\n", ln, this.list.ListTreeRoot.Class.Name+locator.Name);
            sb.AppendFormat("      	this.locator{0}.Location = new System.Drawing.Point(155, 14);\n", ln);
            sb.AppendFormat("      	this.locator{0}.Name = \"locator{0}\";\n", ln);
            sb.AppendFormat("      	this.locator{0}.Operation = Tercom.RealIT.CommonGUI.Locator.MatchOperation.Substring;\n", ln);
            sb.AppendFormat("      	this.locator{0}.Size = new System.Drawing.Size(292, 24);\n", ln);
            sb.AppendFormat("      	this.locator{0}.TabIndex = 0;\n", ln);
            sb.AppendFormat("      	// \n");
            sb.AppendFormat("      	// label{0}\n", ln);
            sb.AppendFormat("      	// \n");
            sb.AppendFormat("      	this.label{0}.AutoSize = true;\n", ln);
            sb.AppendFormat("      	this.label{0}.Location = new System.Drawing.Point(6, 16);\n", ln);
            sb.AppendFormat("      	this.label{0}.Name = \"label{0}\";\n", ln);
            sb.AppendFormat("      	this.label{0}.Size = new System.Drawing.Size(109, 13);\n", ln);
            sb.AppendFormat("      	this.label{0}.TabIndex = 1;\n", ln);
            sb.AppendFormat("      	this.label{0}.Text = \"Поиск по полю \\\"{1}\\\":\";\n", ln, locator.LogicName);
            
            
            return sb.ToString();

        }


    }
}
