﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;
using FormGenerator.Forms;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View.Relationships
{
    public partial class RelationshipProperties : BaseForm
    {
        private ManyToManyRelationship relationship;

        public RelationshipProperties(ManyToManyRelationship relationship)
        {
            this.relationship = relationship;
            InitializeComponent();
            InitializeIntermediateClassSelection(relationship.IntermediateClass);
            InitializePartyClassSelection(relationship.PartyRelation);
            InitializeMemberClassSelection(relationship.MemberRelation);

            foreach (Folder folder in Repository.Repository.Instance.Folders)
            {
                comboBoxFolder.Items.Add(folder);
                if (folder.Equals(relationship.Folder))
                {
                    comboBoxFolder.SelectedItem = folder;
                }
            }

        }

        private void InitializeIntermediateClassSelection(Class ic)
        {
            comboBoxMainClass.Items.Clear();
            foreach (Class c in Repository.Repository.Instance.Classes)
            {
                if (Repository.Repository.Instance.GetMasterClassesRelations(c).Count == 2)
                {
                    comboBoxMainClass.Items.Add(c);
                }
            }
            if (ic == null)
            {
                comboBoxMainClass.SelectedItem = null;
            }
            else
            {
                comboBoxMainClass.SelectedItem = ic;
            }
        }

        private void InitializePartyClassSelection(Relation pr)
        {

            comboBoxPartyClass.Items.Clear();
           
            foreach (Relation r in (Repository.Repository.Instance.GetMasterClassesRelations((Class)comboBoxMainClass.SelectedItem)))
            {
                comboBoxPartyClass.Items.Add(r.MasterClass);
            }
            
            if (pr == null)
            {
                comboBoxPartyClass.SelectedItem = null;
                InitializePartyFieldSelection(null);
            }
            else
            {
                comboBoxPartyClass.SelectedItem = pr.MasterClass;
                InitializePartyFieldSelection(relationship.PartyClassField);
            }
            
            

        }

        private void InitializeMemberClassSelection(Relation mr)
        {
            comboBoxMemberClass.Items.Clear();
            
            foreach (Relation r in (Repository.Repository.Instance.GetMasterClassesRelations((Class)comboBoxMainClass.SelectedItem)))
            {
                comboBoxMemberClass.Items.Add(r.MasterClass);
            }

            if (mr == null)
            {
                comboBoxMemberClass.SelectedItem = null;
                InitializeMemberFieldSelection(null);
            }
            else
            {
                comboBoxMemberClass.SelectedItem = mr.MasterClass;
                InitializeMemberFieldSelection(relationship.MemberClassField);
            }
        }

        private void InitializePartyFieldSelection(Field sf)
        {
            comboBoxPartyField.Items.Clear();
            if (comboBoxPartyClass.SelectedItem != null)
            {
                foreach (Field f in ((Class)(comboBoxPartyClass.SelectedItem)).Fields )
                {
                    comboBoxPartyField.Items.Add(f);
                }
            }
            if (sf == null)
            {
                comboBoxPartyField.SelectedItem = null;
            }
            else
            {
                comboBoxPartyField.SelectedItem = sf;
            }

        }

        private void InitializeMemberFieldSelection(Field sf)
        {
            comboBoxMemberField.Items.Clear();
            if (comboBoxMemberClass.SelectedItem != null)
            {
                foreach (Field f in ((Class)(comboBoxMemberClass.SelectedItem)).Fields)
                {
                    comboBoxMemberField.Items.Add(f);
                }
            }
            if (sf == null)
            {
                comboBoxMemberField.SelectedItem = null;
            }
            else
            {
                comboBoxMemberField.SelectedItem = sf;
            }

        }

        private void comboBoxMainClass_SelectedIndexChanged(object sender, EventArgs e)
        {
            InitializePartyClassSelection(null);
            InitializeMemberClassSelection(null);
        }

        private void comboBoxPartyClass_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBoxPartyClass.SelectedItem != null)
            {
                if (comboBoxPartyClass.SelectedItem.Equals(comboBoxMemberClass.SelectedItem))
                {
                    comboBoxMemberClass.SelectedItem = null;
                }
                InitializePartyFieldSelection(null);
            }
        }

        private void comboBoxMemberClass_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBoxMemberClass.SelectedItem != null)
            {
                if (comboBoxMemberClass.SelectedItem.Equals(comboBoxPartyClass.SelectedItem))
                {
                    comboBoxPartyClass.SelectedItem = null;
                }
                InitializeMemberFieldSelection(null);
            }
        }

        protected override void SaveData()
        {
            if ((comboBoxPartyClass.SelectedItem == null) ||
                (comboBoxMemberClass.SelectedItem == null) ||
                (comboBoxMainClass.SelectedItem == null) ||
                (comboBoxMemberField.SelectedItem == null) ||
                (comboBoxPartyField.SelectedItem == null))
            {
                return;
            }
            else
            {
                relationship.IntermediateClass=(Class)(comboBoxMainClass.SelectedItem);
                relationship.PartyRelation = Repository.Repository.Instance.GetRelation((Class)(comboBoxPartyClass.SelectedItem), relationship.IntermediateClass); 
                relationship.MemberRelation = Repository.Repository.Instance.GetRelation((Class)(comboBoxMemberClass.SelectedItem), relationship.IntermediateClass);
                relationship.PartyClassField = (Field)(comboBoxPartyField.SelectedItem);
                relationship.MemberClassField = (Field)(comboBoxMemberField.SelectedItem);

            }

            relationship.Folder = (Folder)comboBoxFolder.SelectedItem;


            base.SaveData();
        }
        
    }
}
