﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using FormGenerator.Repository;
using FormGenerator.Repository.Forms;

namespace FormGenerator.View
{
    public partial class NewCardForm : System.Windows.Forms.Form
    {
        private Folder currentFolder; 
        public NewCardForm(Folder f)
        {
            InitializeComponent();
            foreach (Class c in Repository.Repository.Instance.Classes)
            {
                ClassNameComboBox.Items.Add(c);
                
                    
            }
            currentFolder = f;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Repository.Repository.Instance.AddNewCard(cardNameTextBox.Text, LogicNameTextBox.Text, (Class)ClassNameComboBox.SelectedItem, currentFolder);
            this.Close();
        }

        private void ClassNameComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            cardNameTextBox.Text = ((Class)ClassNameComboBox.SelectedItem).Name;
            LogicNameTextBox.Text = ((Class)ClassNameComboBox.SelectedItem).LogicName;
        }
    }
}
