﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository
{
    public class Relation:BaseItem
    {
        public const string ZERO_MULTIPLE = "0..*";
        public const string ONE_MULTIPLE = "1..*";
        public const string ZERO_ONE = "0..1";
        public const string ONE = "1";

        private Class slaveClass;
        private Class masterClass;

        private string slaveClassEnd;
        private string masterClassEnd;

        public bool isRelated(Class c1, Class c2)
        {
            if ((slaveClass.Equals(c1) & masterClass.Equals(c2)) | (slaveClass.Equals(c2) & masterClass.Equals(c1)))
            {
                return true;
            }
            else
            {
                return false;
            }

        }

        public Relation(Class masterClass, string masterClassEnd, Class slaveClass, string slaveClassEnd)
        {
            SlaveClass = slaveClass;
            SlaveClassEnd = slaveClassEnd;
            MasterClass = masterClass;
            MasterClassEnd = masterClassEnd;
        }
        
        public string SlaveClassEnd
        {
            get { return slaveClassEnd; }
            set { slaveClassEnd = value; }
        }

        public string MasterClassEnd
        {
            get { return masterClassEnd; }
            set { masterClassEnd = value; }
        }

        public Class SlaveClass
        {
            get { return slaveClass; }
            set { slaveClass = value; }
        }

        public Class MasterClass
        {
            get { return masterClass; }
            set { masterClass = value; }
        }

        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("Relation",
                    new XAttribute("Name", this.Name),
                    new XAttribute("MasterClass", this.MasterClass.Name),
                    new XAttribute("SlaveClass", this.SlaveClass.Name),
                    new XAttribute("MasterClassEnd", this.masterClassEnd),
                    new XAttribute("SlaveClassEnd", this.SlaveClassEnd)
                    );

                return xelement;
            }
        }

        public override string ToString()
        {
            return masterClass.LogicName+">"+slaveClass.LogicName+" ("+this.LogicName+")"; 
        }
    
    
    }
}
