﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;

namespace ParseXMIDocument
{
    /// <summary>
    /// Simple Tree structure
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class TreeNode<T>
    {
        private readonly T data;
        private bool isState;
        private ParseXMI.DiagramElement deType;

        public ParseXMI.DiagramElement DeType
        {
            get { return deType; }
            set { deType = value; }
        }
        private List<TreeNode<T>> children;

        public TreeNode(T data, ParseXMI.DiagramElement deType)
        {
            this.data = data;
            this.isState = true;
            this.deType = deType;
            this.children = new List<TreeNode<T>>();        
        }

        public TreeNode<T> this[int i]
        {
            get
            {
                return children[i];
            }
        }
        public TreeNode<T> Parent { get; private set; }

        public T Data
        {
            get { return data; }
        }
        public bool IsState
        {
            get
            {
                return isState;
            }
            set
            {
                isState = value;
            }
        }
        public ReadOnlyCollection<TreeNode<T>> Children
        {
            get
            {
                return children.AsReadOnly();
            }
        }
        public List<TreeNode<T>> ChildrenNotReadOnly
        {
            get
            {
                return children;
            }
            set
            {
                children = value;
            }
        }
        public TreeNode<T> AddChild(T data, ParseXMI.DiagramElement deType)
        {
            var node = new TreeNode<T>(data, deType);
            node.Parent = this;
            children.Add(node);
            return node;
        }
        //public TreeNode<T>[] AddChildren(params T[] values)
        //{
        //    return values.Select(AddChild).ToArray();
        //}
        public bool Contains(T value)
        {
            if (data.Equals(value))
            {
                return true;
            }
            else 
            {
                return children.Select(ch => ch.Contains(value)).Contains(true);
            }
        }
    }
}
