﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository
{
    public class InformationConnection: BaseItem
    {
        private Class sourceClass;

        public Class SourceClass
        {
            get { return sourceClass; }
            set { sourceClass = value; }
        }
        private Class targetClass;

        public Class TargetClass
        {
            get { return targetClass; }
            set { targetClass = value; }
        }

        private Class informationItem;

        public Class InformationItem
        {
            get { return informationItem; }
            set { informationItem = value; }
        }

        private string source;

        public string Source
        {
            get { return source; }
            set { source = value; }
        }
        private string target;

        public string Target
        {
            get { return target; }
            set { target = value; }
        }

        private ParseXMIDocument.ParseXMI.DiagramElement sourceType;

        public ParseXMIDocument.ParseXMI.DiagramElement SourceType
        {
            get { return sourceType; }
            set { sourceType = value; }
        }
        private ParseXMIDocument.ParseXMI.DiagramElement targetType;

        public ParseXMIDocument.ParseXMI.DiagramElement TargetType
        {
            get { return targetType; }
            set { targetType = value; }

        }

        public InformationConnection
            (Class sClass, Class tClass, Class iItem,
            string source, string target,
            ParseXMIDocument.ParseXMI.DiagramElement sourceType, ParseXMIDocument.ParseXMI.DiagramElement targetType)
        {
            SourceClass = sClass;
            TargetClass = tClass;
            InformationItem = iItem;
            Source = source;
            Target = target;
            SourceType = sourceType;
            TargetType = targetType;
        }

        public XElement XElement
        {
            get 
            {
                XElement xelement = new XElement("informationFlow",
                    new XAttribute("sourceClass", SourceClass.Name),
                    new XAttribute("targetClass", TargetClass.Name),
                    new XAttribute("informationItem", informationItem.Name),
                    new XAttribute("source", source),
                    new XAttribute("target", target),
                    new XAttribute("sourceType", sourceType),
                    new XAttribute("targetType", targetType)
                    );
                return xelement;
            }
        }
    }
}
