﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class Folder
    {
        private string name;
        private string path;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }
        public string Path
        {
            get { return path; }
            set { path = value; }
        }
        
        public XElement XElement
        {
            get
            {
                XElement xelement = new XElement("Folder",
                    new XAttribute("Name", this.Name),
                    new XAttribute("Path", this.Path));

                return xelement;
            }
        }

        public Folder(string name, string path)
        {
            this.name = name;
            this.path = path;
        }

        public Folder(XElement xelement)
        {
            Name = xelement.Attribute("Name").Value;
            Path = xelement.Attribute("Path").Value;
        }

        public override string ToString()
        {
            return name;
        }
    }
}
