﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Linq;

namespace FormGenerator.Repository.Forms
{
    public class Card:Form
    {
        
        private Class c;
        private System.Collections.Generic.List<CardTab> tabs;
        
        
        public Card(string name, string logicName, Class c)
        {
            Name = name;
            LogicName = logicName;
            Class = c;
            tabs = new List<CardTab>();
        }

        public Card(XElement xelement)
        {
            Name = xelement.Attribute("Name").Value;
            LogicName = xelement.Attribute("LogicName").Value;
            Class = Repository.Instance.GetClass(xelement.Attribute("Class").Value);
            
            if (xelement.Attribute("Folder")!=null)
            {
                if (xelement.Attribute("Folder").Value != "")
                {
                    this.Folder = Repository.Instance.GetFolder(xelement.Attribute("Folder").Value);
                }
            }
            tabs = new List<CardTab>();
            foreach (XElement tab in xelement.Element("Tabs").Elements("Tab"))
            {
                tabs.Add(new CardTab(Class, tab));
            }
        }

        public void RestoreTabs(XElement xelement)
        {
            tabs.Clear();
            foreach (XElement tab in xelement.Element("Tabs").Elements("Tab"))
            {
                tabs.Add(new CardTab(Class, tab));
            }
        }

        public Class Class
        {
            get { return c; }
            set { c = value; }
        }

        internal System.Collections.Generic.List<CardTab> Tabs
        {
            get { return tabs; }
            set { tabs = value; }
        }

        public override String ToString()
        {
            return Class.Name;
        }

        public XElement XElement
        {
            get 
            {
                XElement xelement = new XElement("Card",
                    new XAttribute("Name", this.Name),
                    new XAttribute("LogicName", this.LogicName),
                    new XAttribute("Class", this.Class.Name),
                    new XAttribute("Folder", this.Folder==null?"":this.Folder.Path),
                    new XElement("Tabs",
                        from tab in this.Tabs
                        select tab.XElement));

                return xelement;
            }
            

        }     


    }
}
