﻿using System;
using System.Collections.Generic;
using System.Text;
using DevExpress.XtraBars;
using System.Windows.Forms;

namespace GUI
{
    public class MenuConstructor
    {
        private Bar mainBar;
        private Form mainForm;
        private Dictionary<String, Type> forms;

        public MenuConstructor(Bar mainBar, Form mainForm)
        {
            this.mainBar = mainBar;
            this.mainForm = mainForm;
            forms = new Dictionary<String, Type>();
        }

        public void BuildMenu()
        {
ZZMenuItemsZZ
        }


        public void ShowChildForm(Form form)
        {
            try
            {
                if (!Tercom.RealIT.CommonGUI.FormCollection.FindAndActivateSingletoneForm(form))
                {
                    form.MdiParent = mainForm;
                    form.WindowState = FormWindowState.Normal;
                    form.Show();
                }
            }
            catch (Tercom.RealIT.CommonData.LogITException ex)
            {
                Tercom.RealIT.CommonGUI.ServGUI.ShowError("Ошибка при открытии окна." + "\n" + ex.Details, "Ошибка!");
            }
        }

        private void BarButtonItemClickHandler(object sender, ItemClickEventArgs e)
        {
            String name = ((ItemClickEventArgs)e).Item.Name;

            if (forms[name] != null)
            {
                ShowChildForm((Form)(Activator.CreateInstance(forms[name])));
            }
        }

        private void AddSubButtonItem(BarSubItem subItem, string buttonItemName, string buttonItemCaption, Type form)
        {
            BarButtonItem barButtonItemStudents = new BarButtonItem();
            barButtonItemStudents.Caption = buttonItemCaption;
            barButtonItemStudents.Name = buttonItemName;
            barButtonItemStudents.ItemClick += new DevExpress.XtraBars.ItemClickEventHandler(this.BarButtonItemClickHandler);
            subItem.AddItem(barButtonItemStudents);
            forms.Add(buttonItemName, form);
        }


    }
}
