%clear
%% Parameters of the imaging  system
%f0 = 3.5e6;                   %  Transducer center frequency [Hz]
fs = 100e6;                   %  Sampling frequency [Hz]
%c = 1540;                     %  Speed of sound [m/s]
no_lines = 50;                %  Number of scanning lines in image
%image_width = 40 / 1000;      %  Size of image sector
%d_x = image_width / no_lines; %  Increasment step for phantom scanning

%% Reading the data and adjusting it in time

min_sample = 0;

for i = 1 : no_lines   
  cmd = ['load data/rf_ln' num2str(i) '.mat'];
  eval(cmd)
  adj_data = [zeros(round(tstart * fs - min_sample), 1); rf_data];
  signals(1 : size(adj_data, 1), i) = adj_data;
end

signals = signals(4000 : 11500, :);

%% Data decimation
DD = 20;
signals = signals(i : DD : size(signals, 1), :);

%% Raw signals

%  figure('FileName', ['Raw signals N = ' num2str(size(signals, 2)) ' DD = ' num2str(DD)]);
%  x = 1 : size(signals, 1);
%  y = 1 : size(signals, 2);
%  mesh(x, y, signals');
%  title('Raw signals');


%% Data amount enlargement

% disp('data enlargement...')
% %delta = 0.25e-20;
% delta = 0;
% enlargement = 5;
% new_signals = zeros(size(signals, 1), size(signals, 2) * enlargement);
% 
% for i = 1 : size(signals, 1)
%    for j = 1 : size(signals, 2)
%        %temp = [];
%        for k = 1 : enlargement
%            new_signals(i, (j - 1) * enlargement + k) = signals(i, j) + (rand() - 0.5) * 2 * delta;
%            %new_signals = [new_signals; temp];
%        end
%    end
% end
% 
% signals = new_signals;
% disp('done')


%% Data amount enlargement 2
new_N = 50;
delta = 0.125e-20; 

% temp = signals(randperm(size(signals, 1)), 45 : 50);
% signals(:, 35 : 40) = temp;
% img_type = 'single';

temp = signals(:, 15 : 25);
temp = temp(size(temp, 1) : -1 : 1, :);
signals(:, 35 : 45) = temp;
img_type = 'dual';


new_signals = signals;

for i = 1 : (new_N - 50) / 2 / 10
    temp = signals(randperm(size(signals, 1)), 1 : 10);
    new_signals = [temp, new_signals];
end

if mod(new_N - 50, 20) ~= 0
    temp = signals(randperm(size(signals, 1)), 1 : 10);
    new_signals = [temp, new_signals];    
end

for i = 1 : (new_N - 50) / 2 / 10
    temp = signals(randperm(size(signals, 1)), 1 : 10);
    new_signals = [new_signals, temp];
end

noise = rand(size(new_signals));
new_signals = new_signals + delta * noise;

signals = new_signals;

%% Enlarged data

% figure('FileName', ['Original Data N = ' num2str(size(signals, 2)) ' DD = ' num2str(DD)]);
% x = 1 : size(signals, 1);
% y = 1 : size(signals, 2);
% mesh(x, y, signals');
% title('Enlarged data');

%% Using compressive sensing

disp('compressing preparations...')
cs_m = 20;
cs_N = size(signals, 2);

compr_signals   = zeros(size(signals, 1), cs_m);
decompr_signals = zeros(size(signals, 1), size(signals, 2));

%% Matrix construction
A = ceil(3 .* rand(cs_m, cs_N)) - 2;
matr_type = 'uniform';
%matr_type = 'normal';
disp('done')
%% signal transmission
disp('signal transmission...')
disp([num2str(size(signals, 1)) ' iterations'])
for i = 1 : size(signals, 1)
    % compressing
    for j = 1 : cs_m
        compr_signals(i, j) = A(j, :) * signals(i, :)';
    end
    
    % decompressing
    y = compr_signals(i, :);
    
    y = y';
    x0 = A' * y;    
  
    xp = l1qc_logbarrier(x0, A, [], y, 1e-30, 1e-25);
    decompr_signals(i, :) = xp;
    
    if mod(i, 100) == 0
        disp(i)
    end
end
disp('done')


%% Envelope detection
 
signals         = abs(hilbert(signals));
decompr_signals = abs(hilbert(decompr_signals));

%% 3D reconstrunction original 
%Logarithmic compression 
%Compress the data to show 60 dB of dynamic range

D = 1;  % Sampling frequency decimation factor
log_signals = signals(1 : D : size(signals, 1), :) / max(max(signals));
log_signals = 20 * log10(log_signals);
log_signals = 127 / 60 * (log_signals + 60);

figure('FileName', ['Original image N = ' num2str(size(signals, 2)) ' DD = ' num2str(DD) ' m = ' num2str(cs_m) ' ' matr_type ' ' img_type]);
x = 1 : size(log_signals, 1);
y = 1 : size(log_signals, 2);
mesh(x, y, log_signals');
title(['Original image   N = ' num2str(cs_N)]);


%% 3D reconstrunction decompressed 
%Logarithmic compression 
log_decompr_signals = decompr_signals(1 : D : size(decompr_signals, 1), :) / max(max(decompr_signals));
log_decompr_signals = 20 * log10(log_decompr_signals);
log_decompr_signals = 127 / 60 * (log_decompr_signals + 60);

figure('FileName', ['Decompressed image N = ' num2str(size(signals, 2)) ' DD = ' num2str(DD) ' m = ' num2str(cs_m) ' ' matr_type ' ' img_type]);
x = 1 : size(log_decompr_signals, 1);
y = 1 : size(log_decompr_signals, 2);
mesh(x, y, log_decompr_signals');
title(['Decompressed image   m = ' num2str(cs_m) '  N = ' num2str(cs_N)]);

%% significant part of image

figure('FileName', ['Significant part of decompressed image N = ' num2str(size(signals, 2)) ' DD = ' num2str(DD) ' m = ' num2str(cs_m) ' ' matr_type ' ' img_type]);
x = 1 : size(log_decompr_signals, 1);
y = (new_N - 50) / 2 + [1 : 50];
if mod(new_N - 50, 20) ~= 0
    y = y + 5;
end
mesh(x, y, log_decompr_signals(x, y)');
title(['Decompressed image   m = ' num2str(cs_m) '  N = ' num2str(cs_N)]);

figure('FileName', ['Significant part of original image N = ' num2str(size(signals, 2)) ' DD = ' num2str(DD) ' m = ' num2str(cs_m) ' ' matr_type ' ' img_type]);
x = 1 : size(log_signals, 1);
y = (new_N - 50) / 2 + [1 : 50];
if mod(new_N - 50, 20) ~= 0
    y = y + 5;
end
mesh(x, y, log_signals(x, y)');
title(['Original image   m = ' num2str(cs_m) '  N = ' num2str(cs_N)]);