package communitiesGraph;

import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 18.04.13
 * Time: 13:24
 * To change this template use File | Settings | File Templates.
 */
public class CliquesBuilder {
    private Graph graph;
    private Node mainNode;

    public CliquesBuilder(Graph graph, Node mainNode) {
        this.graph = graph;
        this.mainNode = mainNode;
    }

    public List<HashSet<Node>> buildCliques() {
        ArrayList<HashSet<Node>> cliques = new ArrayList<>();

        HashSet<Node> allAvailableNodes = new HashSet<>();
        addNodes(allAvailableNodes, graph.getNodes());
        allAvailableNodes.remove(mainNode);

        /*NeighborsBuilder.NeighborsFilter neighborsFilter = new NeighborsBuilder.NeighborsFilter();
        neighborsFilter.setDepth(1);
        neighborsFilter.setSelf(false);
        */

        while (!allAvailableNodes.isEmpty()) {                         // пока есть доступные вершины делаем
            Node node = (Node) allAvailableNodes.toArray()[0];

            HashSet<Node> not = new HashSet<>();              // множество вершин, которые не вошли в текущую клику
            HashSet<Node> compsub = new HashSet<>();          // текущее множество составляющее полный подграф
            HashSet<Node> candidates = new HashSet<>();       // множество вершин (кандидатов), в которые есть ребро из текущего подграфо
            addNodes(candidates, graph.getNeighbors(node));   // добавляем в множество кандидатов всех соседей вершины node
            candidates.retainAll(allAvailableNodes);          // оставляем во множестве кандидатов только доступные вершины
            compsub.add(node);

            while (!candidates.isEmpty()) {
                for (Node u : candidates) {
                    if (isElemFullSubgraph(compsub, u)) {
                        compsub.add(u);
                        break;
                    } else {
                        not.add(u);
                    }
                }

                HashSet<Node> nghrhood = getNeighbors(compsub);
                candidates = new HashSet<>();
                candidates.addAll(nghrhood);
                candidates.removeAll(not);
                candidates.removeAll(compsub);
                candidates.retainAll(allAvailableNodes);
            }

            if (compsub.size() > 3) {
                cliques.add(compsub);
            }
            allAvailableNodes.removeAll(compsub);
        }
        return cliques;
    }

    private HashSet<Node> addNodes(HashSet<Node> nodes, NodeIterable nodeIterable) {
        for (Node node : nodeIterable) {
            nodes.add(node);
        }
        return nodes;
    }

    private boolean isElemFullSubgraph(HashSet<Node> clique, Node node) {
        HashSet<Node> neighbors = new HashSet<>();
        addNodes(neighbors, graph.getNeighbors(node));
        return neighbors.containsAll(clique);
    }

    private HashSet<Node> getNeighbors(HashSet<Node> nodes) {
        HashSet<Node> neighbors = new HashSet<>();
        for (Node node : nodes) {
            for (Node n : graph.getNeighbors(node)) {
                neighbors.add(n);
            }
        }
        return neighbors;
    }
}
