/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import GraphTesting.DataCollectionForTesting;
import GraphTesting.Testing;
import communities.parseciteceer.Database;
import communities.parseciteceer.GraphDB;
import communities.parseciteceer.MongoDBCreator;
import communitiesGraph.Author;
import communitiesGraph.GraphFromGraphDB;
import communitiesGraph.PaperDescription;
import org.neo4j.graphdb.Node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Main {


    public static void main(String args[]) throws Exception {
        /*communitiesGraph.SearchGraph searchGraph = new communitiesGraph.SearchGraph("Aamodt", EnumSearch.SearchAuthor);
        searchGraph.saveGraph();*/

        // counting author's friends
        //countingFriends("Aamodt");

        //createGraphsData();

        //calculationDBTime();

        //buildGraph();

        /*GraphDB graphDB = new GraphDB();
        Database sqlDB = new Database();
        try {
            //graphDB.buildFromMySQLDatabase();
            Integer authorID = sqlDB.getAuthorIdByName("Aamodt");
            if (authorID == null) {
                System.out.println("Author not found");
                return;
            }

            Iterable<Node> coauthors = graphDB.getCoAuthors(authorID);
            Iterable<Node> citators = graphDB.getCitators(authorID);

            int coauthorsCount = 0;
            for (Node node : coauthors) {
                coauthorsCount++;
            }
            System.out.println("Coauthors count: " + coauthorsCount);

            int citatorsCount = 0;
            for (Node node : citators) {
                citatorsCount++;
            }
            System.out.println("Citattors count: " + citatorsCount);

        } finally {
            graphDB.shutdown();
            sqlDB.closeConnection();
        }*/
        //Node node = graphDB.getAuthorByID(2);
        //System.out.print(node.getProperty("author"));

        //createMongoDB();
        //checkMongoDB();
        //calculateMongoDBTime();

        //cliqueBuild();

        //buildGraphWithCliques();

        generateCliquesTime();
    }

    private static void createBase() {
        /*Database base = new Database();
        base.createDatabaseArticles();
        base.createDatabaseAuthors();
        base.createDatabaseAutorPublication();
        base.createDatabaseCitations();
        ParserCiteSeer.parseAuthors();
        System.out.println("cool");*/
    }

    private static void countingFriends(String authorName) throws Exception {
        GraphDB graphDB = new GraphDB();
        Database sqlDB = new Database();
        try {
            //graphDB.buildFromMySQLDatabase();
            Integer authorID = sqlDB.getAuthorIdByName(authorName);
            if (authorID == null) {
                System.out.println("Author not found");
                return;
            }

            Iterable<Node> coauthors = graphDB.getCoAuthors(authorID);
            int coauthorsCount = 0;
            for (Node node : coauthors) {
                coauthorsCount++;
            }
            System.out.println("Coauthors count: " + coauthorsCount);

            Iterable<Node> citators = graphDB.getCitators(authorID);
            int citatorsCount = 0;
            for (Node node : citators) {
                citatorsCount++;
            }
            System.out.println("Citators count: " + citatorsCount);

            Iterable<Node> coAndCi = graphDB.getCoAuthorsAndCitators(authorID);
            int coauthorsAndCitatorsCount = 0;
            for (Node node : coAndCi) {
                coauthorsAndCitatorsCount++;
            }
            System.out.println("Co and ci count: " + coauthorsAndCitatorsCount);

        } finally {
            graphDB.shutdown();
            sqlDB.closeConnection();
        }
    }

    private static void createGraphsData() {
        DataCollectionForTesting dataCollection = new DataCollectionForTesting();
        dataCollection.createCollection();
        dataCollection.shutdown();
    }

    private static void calculationGenerationTime() {
        Testing testing = new Testing();
        testing.timeGenerationGraph();
    }

    private static void calculationDBTime() {
        Testing testing = new Testing();
        testing.timeSQLDBWork();
    }

    private static void buildGraph() {
        try {
            GraphFromGraphDB sGraph = new GraphFromGraphDB("koen bertels");
            sGraph.saveGraphCSV();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createMongoDB() throws Exception {
        HashMap<Integer, Author> authorByID = new HashMap<>();
        HashMap<Integer, PaperDescription> paperByID = new HashMap<>();

        Database db = new Database();
        try {
            ArrayList<PaperDescription> papers = db.getAllPaperDescriptions();
            for (PaperDescription paper : papers) {
                paperByID.put(paper.getSqlID(), paper);
            }

            ArrayList<Author> authors = db.getAllAuthors();
            for (Author author : authors) {
                authorByID.put(author.getId(), author);
            }

            MongoDBCreator mongoDBCreator = new MongoDBCreator(/*authorByID, paperByID*/);
            try {
                mongoDBCreator.create();
            } finally {
                mongoDBCreator.close();
            }

        } finally {
            db.closeConnection();
        }
    }

    private static void calculateMongoDBTime() {
        Testing testing = new Testing();
        testing.timeMongoDBWork();
    }

    private static void cliqueBuild() throws Exception {
        GraphFromGraphDB graph = new GraphFromGraphDB("Aamodt");
        List<HashSet<org.gephi.graph.api.Node>> cliques = graph.buildCliques();

        System.out.println("Cliques count : " + cliques.size());
        for (HashSet<org.gephi.graph.api.Node> clique : cliques) {
            for (org.gephi.graph.api.Node node : clique) {
                System.out.print(node.getNodeData().getLabel());
            }
            System.out.println();
        }
    }

    private static void buildGraphWithCliques() {
            try {
                GraphFromGraphDB sGraph = new GraphFromGraphDB("uri m. ascher");
                sGraph.saveGraphWithCliques();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    private static void generateCliquesTime() {
        Testing testing = new Testing();
        try {
            testing.generateCliquesTime(0, 5, 10);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}