package GraphTesting;

import communities.parseciteceer.GraphDB;
import communitiesGraph.GraphFromGraphDB;
import communitiesGraph.IScientificGraph;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

import java.util.HashSet;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 22.03.13
 * Time: 15:19
 * To change this template use File | Settings | File Templates.
 */
public class DataCollectionForTesting {
    private GraphDB graphDB;

    public DataCollectionForTesting() {
        graphDB = new GraphDB();
    }

    public void createCollection() {
        XLSWriter writer = new XLSWriter("GraphsData.xls");
        Sheet graphsDataSheet = writer.creteGraphDataSheet();

        try {
            for (int authorID = 1; authorID < 17000; authorID++) {
                HashSet<Node> nodes = new HashSet<>();
                HashSet<Relationship> relations = new HashSet<>();

                Node author = graphDB.getAuthorByID(authorID);
                if (author == null) {
                    continue;
                }
                nodes.add(author);

                for (Node node : graphDB.getCoAuthorsAndCitators(author)) {
                    if (node != null) {
                        nodes.add(node);
                    }
                }

/*                for (Node node : nodes) {
                    for (Relationship relation : node.getRelationships(RelationType.CITATOR, Direction.OUTGOING)) {
                        if (relation != null && nodes.contains(relation.getEndNode()) && nodes.contains(relation.getStartNode())) {
                            relations.add(relation);

                        }
                    }
                    for (Relationship relation : node.getRelationships(RelationType.CO_AUTHORSHIP, Direction.OUTGOING )) {
                        if (relation != null && nodes.contains(relation.getEndNode()) && nodes.contains(relation.getStartNode())) {
                            relations.add(relation);
                        }
                    }
                }*/

                graphsDataSheet.addGraphData(String.valueOf(authorID), (String) author.getProperty(GraphDB.PK_AUTHOR_NAME),
                        nodes.size(), relations.size());

                System.out.println("done: " + authorID);
            }
        } finally {
            writer.write();
        }
    }

    public void shutdown() {
        graphDB.shutdown();
    }
}


