import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;



public class FloydWarshall {

    private static final int INF = Integer.MAX_VALUE / 2;  

  private static int[][] floydWarshallAll(int[][] d) {
      
    int n = d.length;
    int[][] pred = new int[n][n];
    int[][] countOfShortestPaths = new int[n][n];
    for(int[] row : countOfShortestPaths) {
        Arrays.fill(row, 0);
    }
    for (int i = 0; i < n; i++)
      for (int j = 0; j < n; j++)
        pred[i][j] = (i != j && d[i][j] != INF) ? i : -1;
    for (int k = 0; k < n; k++) {
      for (int i = 0; i < n; i++) {
        if (d[i][k] == INF)
          continue;
        for (int j = 0; j < n; j++) {
          if (d[k][j] == INF)
            continue;
          if(d[i][j] == d[i][k] + d[k][j]) {
              countOfShortestPaths[i][j]++;
          }
          if (d[i][j] > d[i][k] + d[k][j]) {
            d[i][j] = Math.max(d[i][k] + d[k][j], -INF);
            pred[i][j] = pred[k][j];
            countOfShortestPaths[i][j] = 0;
          }
        }
      }
    }
//    for (int i = 0; i < n; i++)
//      if (d[i][i] < 0)
//        return null;
//    return pred;
    return countOfShortestPaths;
  }
  
  private static int[][] floydWarshallAcrossNode(int[][] d, int target) {
      
    int n = d.length;
    int[][] pred = new int[n][n];
    int[][] countOfShortestPaths = new int[n][n];
    for(int[] row : countOfShortestPaths) {
        Arrays.fill(row, 0);
    }
    for (int i = 0; i < n; i++)
      for (int j = 0; j < n; j++)
        pred[i][j] = (i != j && d[i][j] != INF) ? i : -1;
    for (int k = 0; k < n; k++) {
      for (int i = 0; i < n; i++) {
        if (d[i][k] == INF)
          continue;
        for (int j = 0; j < n; j++) {
          if (d[k][j] == INF)
            continue;
          if((d[i][j] == d[i][k] + d[k][j]) && (k == target || countOfShortestPaths[i][k] > 0 || countOfShortestPaths[k][j] > 0)) {
              countOfShortestPaths[i][j]++;
          }
          if ((d[i][j] > d[i][k] + d[k][j]) && (k == target || countOfShortestPaths[i][k] > 0 || countOfShortestPaths[k][j] > 0)) {
            d[i][j] = Math.max(d[i][k] + d[k][j], -INF);
            pred[i][j] = pred[k][j];
            countOfShortestPaths[i][j] = 1;
          }
        }
      }
    }
//    for (int i = 0; i < n; i++)
//      if (d[i][i] < 0)
//        return null;
//    return pred;
    return countOfShortestPaths;
  }
 
  public static Map<String, Integer> getBetwennessCentrality(Graph graph) {
      
        Map<String, Integer> code = new HashMap<String, Integer>();
        int i = 0;
        int[][] dist = new int[graph.getNodeCount()][graph.getNodeCount()];
        for (int[] row : dist) {
            Arrays.fill(row, Integer.MAX_VALUE / 2);
        }
        for (Node t : graph.getNodes()) {
            code.put(t.getNodeData().getLabel(), i);
        }

        for (Edge e : graph.getEdges()) {
            dist[code.get(e.getSource().getNodeData().getLabel())][code.get(e.getTarget().getNodeData().getLabel())] = 1;
        }

        
        int[][] countOfShortestPathsAll = floydWarshallAll(dist);

        int resultTMP = 0;
        int[][] countOfShortestPathsAcrossNode;
        
        Map<String, Integer> result = new HashMap<String, Integer>();
        
        for(Node currentNode : graph.getNodes()) {
            
             countOfShortestPathsAcrossNode = floydWarshallAcrossNode(dist, code.get(currentNode.getNodeData().getLabel()));
            
            for(int k = 0; k < graph.getNodeCount(); k++) {
                resultTMP += countOfShortestPathsAcrossNode[code.get(currentNode.getNodeData().getLabel())][k] 
                        / countOfShortestPathsAll[code.get(currentNode.getNodeData().getLabel())][k];
            }
            
            result.put(currentNode.getNodeData().getLabel(), resultTMP);
            resultTMP = 0;
        }
        
        return null;
    }
  
  
}