import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class Dijkstra {

    private static Map<String, Integer> getShortestPaths(Node node, Graph graph) {

        Map<Integer, String> code = new HashMap<Integer, String>();
        int i = 0, s = -1;
        for (Node t : graph.getNodes()) {
            if (t.equals(node)) {
                s = i;
            }
            code.put(i, t.getNodeData().getLabel());
            i++;
        }

        if (s == -1) {
            return null;
        }

        int[] prio = new int[i - 2];
        Arrays.fill(prio, Integer.MAX_VALUE);
        prio[s] = 0;
        PriorityQueue<Long> q = new PriorityQueue<Long>();
        q.add((long) s);
        while (!q.isEmpty()) {
            long cur = q.poll();
            int curu = (int) cur;
            if (cur >>> 32 != prio[curu]) {
                continue;
            }
            for (Edge e : graph.getEdges(graph.getNode(code.get(curu)))) {
                int v = -1;
                for (int j : code.keySet()) {
                    if (code.get(j).equals(e.getTarget().getNodeData().getLabel())) {
                        v = j;
                        break;
                    }
                }

                if (v == -1) {
                    return null;
                }

                int nprio = prio[curu];
                if (prio[v] > nprio) {
                    prio[v] = nprio;
                    //pred[v] = curu;
                    q.add(((long) nprio << 32) + v);
                }
            }
        }

        Map<String, Integer> result = new HashMap<String, Integer>();

        for (i = 0; i < i - 1; i++) {
            if (prio[i] == Integer.MAX_VALUE) {
                result.put(code.get(i + 1), 0);
            } else {
                result.put(code.get(i + 1), prio[i]);
            }
        }
        return result;
    }
    
    public static Map<String, Integer> getClosenessCentrality(Graph graph) {
        Map<String, Integer> result = new HashMap<String, Integer>();
        for (Node node : graph.getNodes()) {
            Map<String, Integer> lengthOfShortestPaths = Dijkstra.getShortestPaths(node, graph);
            int tmp = 0;
            for (String i : lengthOfShortestPaths.keySet()) {
                tmp += (int) Math.pow(2, -lengthOfShortestPaths.get(i));
            }
            result.put(node.getNodeData().getLabel(), tmp);
        }
        return result;
    }
}