package communitiesGraph;

import communities.parseciteceer.Database;
import org.gephi.graph.api.*;
import org.gephi.graph.api.Node;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/**
 * Created with IntelliJ IDEA. User: nikita Date: 28.09.12 Time: 20:31 To change
 * this template use File | Settings | File Templates.
 */
public class SearchGraph extends GraphCreator implements IScientificGraph {
    private HashMap<Integer, Node> idToNode;

    long dbWorkTime = 0;

    public long getDbWorkTime() {
        return dbWorkTime;
    }

    public SearchGraph(String request, EnumSearch enumSearch) throws Exception {
        super(request);

        idToNode = new HashMap<>();
        //createFromNeo4j();
        createFromMySQL(enumSearch);
        setNodeSize();
    }

    private void createFromMySQL(EnumSearch enumSearch) throws Exception {
        long timeInStart = System.currentTimeMillis();

        idToNode = new HashMap<>();

        ArrayList<Paper> listOfPapers = new ArrayList<>();
        Database database = new Database();
        try {
            // Get list ID of paper that under review from database
            HashSet<Integer> listPapersID;
            if (enumSearch == EnumSearch.SearchPaper) {
                listPapersID = new HashSet<>(database.getIdPapers(requestSearch));
            } else {
                listPapersID = new HashSet<>(database.getIdOfPapersByAuthor(requestSearch));
            }

            // Get list of papers with authors from database
            for (Integer paperID : listPapersID) {
                try {
                    Paper paper = new Paper(paperID, database.getAuthorsByPaperId(paperID), database.getAuthorsCitated(paperID));
                    listOfPapers.add(paper);
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            database.closeConnection();
        }


        long timeAfterDatabaseWork = System.currentTimeMillis();
        // Create graph from authors of papers
        for (Paper paper : listOfPapers) {
            ArrayList<Author> authors = paper.getAuthors();
            while (!authors.isEmpty()) {
                Node authorNode = addNode(authors.get(0), graphModel);
                for (Author citingAuthor : paper.getCitingAuthors()) {
                    Node citingAuthorNode = addNode(citingAuthor, graphModel);
                    graph.addEdge(graphModel.factory().newEdge(authorNode, citingAuthorNode, 2f, false));
                }
                for (Author otherAuthor : paper.getAuthors()) {
                    Node otherAuthorNode = addNode(otherAuthor, graphModel);
                    graph.addEdge(graphModel.factory().newEdge(authorNode, otherAuthorNode, 4f, true));
                }
                authors.remove(0);
            }
        }
        long timeAfterGraphCreate = System.currentTimeMillis();

        long timeInEnd = System.currentTimeMillis();
        System.out.println("Request : " + requestSearch);
        dbWorkTime = timeAfterDatabaseWork - timeInStart;
        System.out.println("Database work time = " + (timeAfterDatabaseWork - timeInStart));
        System.out.println("Graph create time = " + (timeAfterGraphCreate - timeAfterDatabaseWork));
        System.out.println("communitiesGraph.SearchGraph work time = " + (timeInEnd - timeInStart));
        System.out.println("Count of node : " + graph.getNodeCount() + '\n');
    }

    private int getAuthorID(String request) throws Exception {
        Database database = new Database();
        try {
            return database.getAuthorIdByName(request);
        } finally {
            database.closeConnection();
        }

    }

    private Node addNode(Author author, GraphModel graphModel) {
        if (idToNode.containsKey(author.getId())) {
            return idToNode.get(author.getId());
        }
        Node authorNode = graphModel.factory().newNode(String.valueOf(author.getId()));
        authorNode.getNodeData().setLabel(author.getName());
        authorNode.getNodeData().setSize(10f);
        graph.addNode(authorNode);
        idToNode.put(author.getId(), authorNode);

        return authorNode;
    }

    public static Map<String, Integer> getDegreeCentrality(Graph graph) {
        int maxDegree = 1;
        Map<String, Integer> result = new HashMap<>();
        for (Node node : graph.getNodes()) {
            if (graph.getDegree(node) > maxDegree) {
                maxDegree = graph.getDegree(node);
            }
        }
        for (Node node : graph.getNodes()) {
            result.put(node.getNodeData().getLabel(), graph.getDegree(node) / maxDegree);
        }
        return result;
    }
}