package communitiesGraph;

import communities.parseciteceer.Database;
import communities.parseciteceer.MongoDBReader;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Node;

import java.util.HashMap;
import java.util.HashSet;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 01.04.13
 * Time: 16:05
 * To change this template use File | Settings | File Templates.
 */
public class GraphFromMongoDB extends GraphCreator {

    private HashMap<Integer, Node> nodeById;

    public GraphFromMongoDB(String requestSearch) throws Exception {
        super(requestSearch);
        nodeById = new HashMap<>();
    }

    public long createGraph() throws Exception {
        MongoDBReader mongoReader = new MongoDBReader();

        try {

            int authorID = getAuthorID(requestSearch);
            Author sourceAuthor = mongoReader.getAuthor(authorID);
            Node sourceAuthorNode = createNode(sourceAuthor);
            graph.addNode(sourceAuthorNode);

            HashSet<Author> coauthors = mongoReader.getCoauthors(authorID);
            for (Author author : coauthors) {
                Node node = createNode(author);
                graph.addNode(node);
                Edge edge = graphModel.factory().newEdge(sourceAuthorNode, node, CO_AUTHOR_RELATION_SIZE, false);
                graph.addEdge(edge);
            }

            HashSet<Author> citators = mongoReader.getCitators(authorID);
            for (Author author : citators) {
                Node node = createNode(author);
                graph.addNode(node);
                Edge edge = graphModel.factory().newEdge(sourceAuthorNode, node, CITATOR_RELATION_SIZE, false);
                graph.addEdge(edge);
            }

            for (Author author : coauthors) {
                addRelations(author, mongoReader);
            }

            for (Author author : citators) {
                addRelations(author, mongoReader);
            }

        } finally {
            mongoReader.close();
        }
        return mongoReader.getTimeWork();
    }

    private void addRelations(Author author, MongoDBReader mongoReader) {
        Node authorNode = nodeById.get(author.getId());

        if (authorNode != null) {
            HashSet<Author> coauthors = mongoReader.getCoauthors(author.getId());
            HashSet<Author> citators = mongoReader.getCitators(author.getId());

            for (Author a : coauthors) {
                Edge edge = createEdge(authorNode, a, CO_AUTHOR_RELATION_SIZE, false);
                if (edge != null) {
                    graph.addEdge(edge);
                }
            }
            for (Author a : citators) {
                Edge edge = createEdge(authorNode, a, CITATOR_RELATION_SIZE, false);
                if (edge != null) {
                    graph.addEdge(edge);
                }
            }
        }
    }

    private Edge createEdge(Node sourceNode, Author endAuthor, float relSize, boolean direction) {
        Node endNode = nodeById.get(endAuthor.getId());
        if (endNode != null) {
            return graphModel.factory().newEdge(sourceNode, endNode, relSize, direction);
        }
        return null;
    }

    private int getAuthorID(String request) throws Exception {
        Database database = new Database();
        try {
            return database.getAuthorIdByName(request);
        } finally {
            database.closeConnection();
        }
    }

    private Node createNode(Author author) {
        Integer authorID = author.getId();
        Node node;
        if (!nodeById.containsKey(author.getId())) {
            node = graphModel.factory().newNode(authorID.toString());
            node.getNodeData().setLabel(author.getName());
            nodeById.put(author.getId(), node);
        } else {
            node = nodeById.get(author.getId());
        }
        return node;
    }
}
