package communitiesGraph;

import org.gephi.graph.api.*;
import org.gephi.io.exporter.api.ExportController;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

import java.awt.*;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 01.04.13
 * Time: 16:06
 * To change this template use File | Settings | File Templates.
 */
public abstract class GraphCreator implements IScientificGraph {
    protected final static ProjectController pc = Lookup.getDefault().lookup(ProjectController.class);
    protected final static Workspace workspace;

    public static final float CO_AUTHOR_RELATION_SIZE = 8f;
    public static final float CITATOR_RELATION_SIZE = 5f;

    private static final String CLIQUE_KEY = "clique_number";

    static {
        getPc().newProject();
        workspace = getPc().getCurrentWorkspace();
    }

    public static ProjectController getPc() {
        return pc;
    }

    protected final Graph graph;
    protected final String requestSearch;
    protected final GraphModel graphModel;
    protected Node mainNode;

    public GraphCreator(String requestSearch) {
        this.requestSearch = requestSearch;

        graphModel = Lookup.getDefault().lookup(GraphController.class).getModel(workspace);
        graphModel.clear();

        graph = graphModel.getMixedGraph();

        cleanGraph();
    }

    private void cleanGraph() {
        if (graph.getNodeCount() != 0) {
            System.out.println("Created isn't empty graph! >_<");
            for (Edge edge : graph.getEdges()) {
                graph.removeEdge(edge);
            }
            for (Node node : graph.getNodes()) {
                graph.removeNode(node);
            }
        }
    }

    public Graph getGraph() {
        return graph;
    }

    public String saveGraph() {
        String filename = requestSearch.toLowerCase() + ".gexf";

        ExportController ec = Lookup.getDefault().lookup(ExportController.class);
        GraphExporter exporter = (GraphExporter) ec.getExporter("gexf");
        exporter.setExportVisible(true);
        try {
            File file = new File("/Users/nikita/IdeaProjects/commining/web/" + filename);
            //File file = new File("/usr/share/tomcat7/webapps/search/" + filename);
            file.createNewFile();
            file.setWritable(true);
            ec.exportFile(file, exporter);
        } catch (IOException e2) {
            e2.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
            System.out.println("Error");
        }

        return filename;
    }

    public String saveGraphCSV() {
        String filename = requestSearch.toLowerCase() + ".csv";

        ExportController ec = Lookup.getDefault().lookup(ExportController.class);
        MyExporterCSV csvExporter = new MyExporterCSV();
        //GraphExporter exporter = (GraphExporter) ec.getExporter("csv");
        //((ExporterCSV) exporter).setList(true);
        csvExporter.setExportVisible(true);
        csvExporter.setNormalize(true);
        try {
            File file = new File("/Users/nikita/IdeaProjects/commining/web/" + filename);
            //File file = new File("/usr/share/tomcat7/webapps/search/" + filename);
            file.createNewFile();
            file.setWritable(true);
            ec.exportFile(file, csvExporter);
        } catch (IOException e2) {
            e2.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
            System.out.println("Error");
        }

        return filename;
    }

    public void setNodeSize() {
        int maxDegree = 1;
        int minDegree = Integer.MAX_VALUE;
        int maxSize = 30;
        int minSize = 10;

        for (Node node : graph.getNodes()) {
            int nodeDegree = graph.getDegree(node);
            if (nodeDegree > maxDegree) {
                maxDegree = nodeDegree;
            } else if (nodeDegree < minDegree && nodeDegree != 0) {
                minDegree = nodeDegree;
            }
        }
        for (Node node : graph.getNodes()) {
            int nodeDegree = graph.getDegree(node);
            node.getNodeData().setSize((nodeDegree * (maxSize - minSize) / maxDegree + minSize));
            node.getNodeData().setColor(0.2f, 0.6f, 0.0f);
        }
    }

    public List<HashSet<Node>> buildCliques() {
        CliquesBuilder cb = new CliquesBuilder(graph, mainNode);
        return cb.buildCliques();
    }

    public void addCliques(List<HashSet<Node>> cliques) {
        ArrayList<Node> cliquesNodes = new ArrayList<>();
        Integer[] colors = new Integer[]{0x0088cc, 0xee5f5b, 0xe6e6e6, 0x62c462, 0xf89406, 0x2f96b4, 0x0044cc, 0xbd362f, 0x51a351, 0xfbb450, 0x5bc0de};

        // Create and add cliques nodes.
        // For each node that contains in clique create edge between cliqueNode and the node with weight -1
        for (int i = 0; i < cliques.size(); i++) {
            Color cliqueColor = new Color(colors[i % colors.length]);
            HashSet<Node> clique = cliques.get(i);
            String cliqueName = String.valueOf(clique.size());

            int j = 0;
            for (Node n : clique) {
                if (j > 1) {
                    break;
                } else if (j == 0) {
                    cliqueName += ": ";
                } else {
                    cliqueName += ", ";
                }
                cliqueName += n.getNodeData().getLabel();
                j++;
            }

            Node cliqueNode = graphModel.factory().newNode("Clique " + i);
            cliqueNode.getNodeData().setLabel(cliqueName);
            cliqueNode.getNodeData().setSize(30f);
            cliqueNode.getAttributes().setValue("isClique", true);
            cliqueNode.getNodeData().setColor(cliqueColor.getRed() / 255f, cliqueColor.getGreen() / 255f, cliqueColor.getBlue() / 255f);

            graph.addNode(cliqueNode);
            cliquesNodes.add(i, cliqueNode);

            for (Node node : clique) {
                Edge edge = graphModel.factory().newEdge(cliqueNode, node, -1f, false);
                graph.addEdge(edge);

                node.getAttributes().setValue(CLIQUE_KEY, i);
                node.getNodeData().setColor(cliqueColor.getRed() / 255f, cliqueColor.getGreen() / 255f, cliqueColor.getBlue() / 255f);
            }
        }

        // For each cliqueNode add edges with neighbors and edges between cliques
        boolean[][] matrix = new boolean[cliques.size()][cliques.size()];
        for (int i = 0; i < cliques.size(); i++) {
            Node cliqueNode = cliquesNodes.get(i);
            HashSet<Node> clique = cliques.get(i);

            HashSet<Node> neighbors = new HashSet<>();
            for (Node node : clique) {
                for (Node neighbor : graph.getNeighbors(node)) {
                    neighbors.add(neighbor);
                }
            }

            for (Node neighborNode : neighbors) {
                Edge edge = graphModel.factory().newEdge(cliqueNode, neighborNode, CITATOR_RELATION_SIZE, false);
                graph.addEdge(edge);

                Integer cliqueNumber = (Integer) neighborNode.getAttributes().getValue(CLIQUE_KEY);
                if (cliqueNumber != null && cliqueNumber < cliques.size() && !matrix[i][cliqueNumber]) {
                    Node neighborCliqueNode = cliquesNodes.get(cliqueNumber);

                    Edge e = graphModel.factory().newEdge(cliqueNode, neighborCliqueNode, CITATOR_RELATION_SIZE, false);
                    graph.addEdge(e);

                    matrix[cliqueNumber][i] = true;
                    matrix[i][cliqueNumber] = true;
                }
            }
        }
    }

    public long generateCliquesTime() {
        long startTime = System.currentTimeMillis();
        List<HashSet<Node>> cliques = buildCliques();
        addCliques(cliques);
        long endTime = System.currentTimeMillis();
        return (endTime - startTime);
    }

    public String saveGraphWithCliques() {
        String filename = requestSearch.toLowerCase() + ".csv";

        List<HashSet<Node>> cliques = buildCliques();
        addCliques(cliques);

        ExportController ec = Lookup.getDefault().lookup(ExportController.class);
        MyExporterCSV cliquesExporter = new MyExporterCSV();

        cliquesExporter.setExportVisible(true);
        cliquesExporter.setNormalize(false);

        try {
            File file = new File("/Users/nikita/IdeaProjects/commining/web/" + filename);
            //File file = new File("/usr/share/tomcat7/webapps/search/" + filename);
            file.createNewFile();
            file.setWritable(true);
            ec.exportFile(file, cliquesExporter);
        } catch (IOException e2) {
            e2.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
            System.out.println("Error");
        }

        return filename;
    }
}
