/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package communitiesGraph;

import java.io.Serializable;

/**
 * @author Владимир
 */
public class Author implements Serializable, Comparable<Author> {
    private int id;
    private String name;
    private String cite;
    private String url;

    public Author(int id, String name, String cite, String url) {
        this.id = id;
        this.name = name;
        this.cite = cite;
        this.url = url;
    }

    public String getSite() {
        return cite;
    }

    public String getUrl() {
        return url;
    }

    public String getName() {
        return name;
    }

    public int getId() {
        return id;
    }


    public boolean equals(Object obj) {
        Author tmp = (Author) obj;
        return tmp.id == this.id;
    }

    public int compareTo(Author o) {
        if (this.id == o.id) {
            return 0;
        } else if (this.id > o.id) {
            return 1;
        } else {
            return -1;
        }
    }

    public int hashCode() {
        return id;
    }
}
