package communities.parseciteceer;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import communitiesGraph.Author;

import java.net.UnknownHostException;
import java.util.HashSet;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 01.04.13
 * Time: 15:02
 * To change this template use File | Settings | File Templates.
 */
public class MongoDBReader extends MongoDB {
    private DBCollection collectionAuthors;
    private DBCollection collectionPapers;

    private long timeWork;

    public MongoDBReader() throws UnknownHostException {
        super();

        collectionAuthors = db.getCollection(COLLECTION_AUTHORS);
        collectionPapers = db.getCollection(COLLECTION_PAPERS);

        timeWork = 0;
    }

    private DBObject getAuthorByName(String authorName) {
        return collectionAuthors.findOne(new BasicDBObject(AUTHOR_NAME, authorName));
    }

    public Author getAuthor(int authorID) {
        long time = System.currentTimeMillis();
        DBObject dbAuthor = getAuthorByID(authorID);
        Author author = convertToAuthor(dbAuthor);
        timeWork += System.currentTimeMillis() - time;

        return author;
    }

    private DBObject getAuthorByID(int authorID) {
        return collectionAuthors.findOne(new BasicDBObject(AUTHOR_SQL_ID, authorID));
    }

    private DBObject getPaperBYTitle(String title) {
        return collectionPapers.findOne(new BasicDBObject(PAPER_TITLE, title));
    }

    private BasicDBList getAuthorsOfPaper(DBObject paper) {
        return (BasicDBList) paper.get(PAPER_AUTHOR);
    }

    private BasicDBList getCitatorsOfPaper(DBObject dbPaper) {
        return (BasicDBList) dbPaper.get(PAPER_CITATORS);
    }

    private Author convertToAuthor(DBObject dbAuthor) {
        String name = (String) dbAuthor.get(AUTHOR_NAME);
        int id = (Integer) dbAuthor.get(AUTHOR_SQL_ID);
        String cite = (String) dbAuthor.get(AUTHOR_CITE);
        String url = (String) dbAuthor.get(AUTHOR_URL);

        return new Author(id, name, cite, url);
    }

    public HashSet<Author> getCoauthors(int authorID) {
        long time = System.currentTimeMillis();
        DBObject dbAuthor = getAuthorByID(authorID);
        HashSet<Author> coauthors = getCoauthors(dbAuthor);
        timeWork += System.currentTimeMillis() - time;

        return coauthors;
    }

    private HashSet<Author> getCoauthors(DBObject dbAuthor) {
        BasicDBList listOfPapers = (BasicDBList) dbAuthor.get(AUTHOR_PAPERS);
        HashSet<Author> authors = new HashSet<>();

        for (Object objPaper : listOfPapers) {
            DBObject dbPaper = (DBObject) objPaper;
            BasicDBList listOfAuthors = getAuthorsOfPaper(dbPaper);
            for (Object objAuthor : listOfAuthors) {
                Author author = convertToAuthor((DBObject) objAuthor);
                authors.add(author);
            }
        }
        return authors;
    }

    public HashSet<Author> getCitators(int authorID) {
        long time = System.currentTimeMillis();

        DBObject dbAuthor = getAuthorByID(authorID);
        HashSet<Author> citators = getCitators(dbAuthor);
        timeWork += System.currentTimeMillis() - time;

        return citators;
    }

    private HashSet<Author> getCitators(DBObject dbAuthor) {
        BasicDBList listOfPapers = (BasicDBList) dbAuthor.get(AUTHOR_PAPERS);
        HashSet<Author> citatros = new HashSet<>();

        for (Object objPaper : listOfPapers) {
            DBObject dbPaper = (DBObject) objPaper;
            BasicDBList listOfCitators = getCitatorsOfPaper(dbPaper);
            for (Object objAuthor : listOfCitators) {
                Author author = convertToAuthor((DBObject) objAuthor);
                citatros.add(author);
            }
        }
        return citatros;
    }

    public long getTimeWork() {
        return timeWork;
    }
}
