package communities.parseciteceer;

import com.mongodb.*;
import communitiesGraph.Author;
import communitiesGraph.PaperDescription;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 31.03.13
 * Time: 13:59
 * To change this template use File | Settings | File Templates.
 */
public class MongoDBCreator extends MongoDB {
    private MongoClient client;
    private DB db;

    private HashMap<Integer, Author> authorBySqlId;
    private HashMap<Integer, PaperDescription> paperBySqlId;

    public MongoDBCreator() throws UnknownHostException {
        client = new MongoClient();

        db = client.getDB(DATABASE_NAME);
        db.authenticate("admin", new char[]{'m', 'o', 'n', 'g', 'o', 's', 'w', 'o', 'r', 'd'});

        authorBySqlId = new HashMap<>();
        paperBySqlId = new HashMap<>();
    }

    public MongoDBCreator(HashMap<Integer, Author> authorBySqlId, HashMap<Integer, PaperDescription> paperBySqlId) throws UnknownHostException {
        client = new MongoClient();

        db = client.getDB(DATABASE_NAME);
        db.authenticate("admin", new char[]{'m', 'o', 'n', 'g', 'o', 's', 'w', 'o', 'r', 'd'});

        this.authorBySqlId = authorBySqlId;
        this.paperBySqlId = paperBySqlId;
    }

    private BasicDBObject createAuthorDoc(Author author) {
        return new BasicDBObject(AUTHOR_NAME, author.getName())
                .append(AUTHOR_SQL_ID, author.getId())
                .append(AUTHOR_URL, author.getUrl())
                .append(AUTHOR_CITE, author.getSite());
    }

    private BasicDBObject createPaperDoc(PaperDescription paper) {
        return new BasicDBObject(PAPER_TITLE, paper.getTitle())
                .append(PAPER_SQL_ID, paper.getSqlID())
                .append(PAPER_URL, paper.getUrl())
                .append(PAPER_CITE, paper.getCite())
                .append(PAPER_ABSTRACT, paper.getAbstr())
                .append(PAPER_YEAR_PUBLICATION, paper.getYear());
    }

    private void addCoauthors(DBObject paper, BasicDBList coauthors) {
        paper.put(PAPER_AUTHOR, coauthors);
    }

    private void addCitators(DBObject paper, BasicDBList citators) {
        paper.put(PAPER_CITATORS, citators);
    }

    private void addPapers(DBObject author, BasicDBList papers) {
        author.put(AUTHOR_PAPERS, papers);
    }

    private DBCollection createAuthorCollection() {
        DBCollection collectionAuthors = db.getCollection(COLLECTION_AUTHORS);
        collectionAuthors.drop();
        collectionAuthors = db.getCollection(COLLECTION_AUTHORS);
        for (Author author : authorBySqlId.values()) {
            db.requestStart();
            try {
                db.requestEnsureConnection();
                collectionAuthors.insert(createAuthorDoc(author));
            } finally {
                db.requestDone();
            }
        }
        System.out.println("Authors created");

        return collectionAuthors;
    }

    private DBCollection createPaperCollection() {
        DBCollection collectionPapers = db.getCollection(COLLECTION_PAPERS);
        collectionPapers.drop();
        collectionPapers = db.getCollection(COLLECTION_PAPERS);
        for (PaperDescription paper : paperBySqlId.values()) {
            db.requestStart();
            try {
                db.requestEnsureConnection();
                collectionPapers.insert(createPaperDoc(paper));
            } finally {
                db.requestDone();
            }
        }
        System.out.println("Papers created");
        return collectionPapers;
    }

    private void createAuthorIndexes() {
        DBCollection collectionAuthors = db.getCollection(COLLECTION_AUTHORS);
        db.requestStart();
        try {
            db.requestEnsureConnection();
            collectionAuthors.ensureIndex(AUTHOR_NAME);
            collectionAuthors.createIndex(new BasicDBObject(AUTHOR_SQL_ID, 1));
        } finally {
            db.requestDone();
        }
        System.out.println("Index for authors added");
    }

    private void createPaperIndexes() {
        DBCollection collectionPapers = db.getCollection(COLLECTION_PAPERS);
        db.requestStart();
        try {
            db.requestEnsureConnection();
            collectionPapers.ensureIndex(PAPER_TITLE);
            collectionPapers.createIndex(new BasicDBObject(PAPER_SQL_ID, 1));
        } finally {
            db.requestDone();
        }
        System.out.println("Index for papers added");
    }

    private void addAuthorsAndCitators() throws Exception {
        DBCollection collectionAuthors = db.getCollection(COLLECTION_AUTHORS);
        DBCollection collectionPapers = db.getCollection(COLLECTION_PAPERS);

        Database sqldb = new Database();
        try (DBCursor dbCursor = collectionPapers.find()) {
            while (dbCursor.hasNext()) {
                DBObject dbPaper = dbCursor.next();
                int paperID = Integer.parseInt(dbPaper.get(PAPER_SQL_ID).toString());

                ArrayList<Author> coauthors = sqldb.getAuthorsByPaperId(paperID);
                ArrayList<Author> citators = sqldb.getAuthorsCitated(paperID);

                BasicDBList coauthorsDBList = new BasicDBList();
                for (Author author : coauthors) {
                    DBObject dbAuthor = collectionAuthors.findOne(new BasicDBObject(AUTHOR_SQL_ID, author.getId()));
                    coauthorsDBList.add(dbAuthor);
                }
                addCoauthors(dbPaper, coauthorsDBList);

                BasicDBList citatorsDBList = new BasicDBList();
                for (Author author : citators) {
                    DBObject dbAuthor = collectionAuthors.findOne(new BasicDBObject(AUTHOR_SQL_ID, author.getId()));
                    citatorsDBList.add(dbAuthor);
                }
                addCitators(dbPaper, citatorsDBList);

                db.requestStart();
                try {
                    db.requestEnsureConnection();
                    collectionPapers.save(dbPaper);
                } finally {
                    db.requestDone();
                }

                System.out.println("done paper: " + paperID);
            }
        } finally {
            sqldb.closeConnection();
        }
    }

    public void create() throws Exception {
/*        DBCollection collectionAuthors = createAuthorCollection();
        DBCollection collectionPapers = createPaperCollection();

        createAuthorIndexes();
        createPaperIndexes();*/

        DBCollection collectionAuthors = db.getCollection(COLLECTION_AUTHORS);
        DBCollection collectionPapers = db.getCollection(COLLECTION_PAPERS);

        // Add authors and citators for papers
        /*addAuthorsAndCitators();
        System.out.println("Authors and citators for papers added");*/

        Database sqldb = new Database();
        try (DBCursor authorsCursor = collectionAuthors.find()) {
            while (authorsCursor.hasNext()) {
                DBObject dbAuthor = authorsCursor.next();

                BasicDBList papersDBList = new BasicDBList();
                int authorID = Integer.parseInt(dbAuthor.get(AUTHOR_SQL_ID).toString());
                for (Integer paperID : sqldb.getPapersIDByAuthorID(authorID)) {
                    DBObject dbPaper = collectionPapers.findOne(new BasicDBObject(PAPER_SQL_ID, paperID));
                    papersDBList.add(dbPaper);
                }
                addPapers(dbAuthor, papersDBList);

                db.requestStart();
                try {
                    db.requestEnsureConnection();
                    collectionAuthors.save(dbAuthor);
                } finally {
                    db.requestDone();
                }
                System.out.println("done author: " + authorID);
            }
        } finally {
            sqldb.closeConnection();
        }
        System.out.println("Authors saved");
    }
}
