package communities.parseciteceer;

import com.mongodb.DB;
import com.mongodb.MongoClient;

import java.net.UnknownHostException;

/**
 * Created with IntelliJ IDEA.
 * User: nikita
 * Date: 31.03.13
 * Time: 13:50
 * To change this template use File | Settings | File Templates.
 */
public abstract class MongoDB {
    // Database name
    public static final String DATABASE_NAME = "citeseer";

    // Names of collections
    public static final String COLLECTION_AUTHORS = "authors";
    public static final String COLLECTION_PAPERS = "papers";

    // Names for author collection
    public static final String AUTHOR_SQL_ID = "id";
    public static final String AUTHOR_NAME = "name";
    public static final String AUTHOR_URL = "url";
    public static final String AUTHOR_CITE = "cite";
    public static final String AUTHOR_PAPERS = "papers";

    //Names for paper collection
    public static final String PAPER_SQL_ID = "id";
    public static final String PAPER_TITLE = "title";
    public static final String PAPER_URL = "url";
    public static final String PAPER_CITE = "cite";
    public static final String PAPER_ABSTRACT = "abstract";
    public static final String PAPER_YEAR_PUBLICATION = "year";
    public static final String PAPER_AUTHOR = "author";
    public static final String PAPER_CITATORS = "citators";

    protected MongoClient client;
    protected DB db;

    public MongoDB() throws UnknownHostException {
        client = new MongoClient();

        db = client.getDB(DATABASE_NAME);
        db.authenticate("admin", new char[]{'m', 'o', 'n', 'g', 'o', 's', 'w', 'o', 'r', 'd'});
    }

    public void close() {
         client.close();
    }
}
