package communities.parseciteceer;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import com.mysql.jdbc.PreparedStatement;
import communitiesGraph.Author;
import communitiesGraph.Paper;
import communitiesGraph.PaperDescription;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

/**
 * @author Владимир
 */
public class Database {
    private static final String databaseName = "CiteCeer";
    private Connection connection;

    public static final String PAPER_ID = "paper_id";
    public static final String PAPER_TITLE = "paper";
    public static final String PAPER_URL = "url";
    public static final String PAPER_CITE = "cite";
    public static final String PAPER_ABSTRACT = "abstract";
    public static final String PAPER_YEAR_PUBLICATION = "year_publication";

    public static final String AUTHOR_TABLE = "authors";
    public static final String PAPER_TABLE = "papers";

    public static final String AUTHOR_ID = "author_id";

    public Database() throws Exception {
        connection = getConnection();
    }

    private Connection getConnection() throws Exception {
        Class.forName("org.gjt.mm.mysql.Driver").newInstance();

        String url = "jdbc:mysql://localhost/" + databaseName;
        String username = "root";
        String password = "mysqlsword";
        return DriverManager.getConnection(url, username, password);
    }

    public void closeConnection() throws SQLException {
        connection.close();
    }

    public void insertInAffiliations(String affiliation) throws SQLException {
        if (!affiliation.equals("")) {
            PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(
                    "SELECT affiliation_id FROM affiliations WHERE affiliation=?;");
            stmt.setString(1, affiliation);
            ResultSet rs = stmt.executeQuery();
            if (rs.first()) {
                return;
            }
            stmt = (PreparedStatement) connection.prepareStatement(
                    "INSERT INTO affiliations (affiliation) Values (?)");
            stmt.setString(1, affiliation);
            stmt.executeUpdate();
            stmt.close();
            connection.close();
        }
    }

    public void insertInPublishersTable(String publisher) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT publisher_id FROM publishers WHERE publisher=?;");
        stmt.setString(1, publisher);
        ResultSet rs = stmt.executeQuery();
        if (rs.first()) {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement(
                "INSERT INTO publishers (publisher) Values (?);");
        stmt.setString(1, publisher);
        stmt.executeUpdate();
    }

    public void insertInAuthorAffiliation(String name, String affiliation) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT affiliation_id  FROM affiliations WHERE affiliation=?;");
        stmt.setString(1, affiliation);
        ResultSet rs = stmt.executeQuery();
        if (!rs.first()) {
            return;
        }
        int id_affilation = rs.getInt("affiliation_id");
        stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT author_id  FROM authors WHERE author=?;");
        stmt.setString(1, name);
        rs = stmt.executeQuery();
        if (!rs.first()) {
            return;
        }
        int id_author = rs.getInt("author_id");
        stmt = (PreparedStatement) connection.prepareStatement(
                String.format("INSERT INTO author_affiliation (author_id, affiliation_id) "
                        + "Values (%d,%d);", id_author, id_affilation));
        stmt.executeUpdate();
    }

    public void insertInTableAuthors(String author, String URL) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT author_id  FROM authors WHERE author=?;");
        stmt.setString(1, author);
        ResultSet rs = stmt.executeQuery();
        if (rs.first()) {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement("INSERT INTO authors "
                + "Values (NULL,?,?,'citeseer' );");
        stmt.setString(1, author);
        stmt.setString(2, URL);
        stmt.executeUpdate();
    }

    public void insertInTablePapers(String title, String authors, int yearPublication,
                                    String publisher, String URL, String abstractText) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT paper_id  FROM papers WHERE paper=?;");
        stmt.setString(1, title);
        ResultSet rs = stmt.executeQuery();
        if (rs.first()) {
            return;
        }
        int id_publisher = 0;
        if (publisher != null) {
            insertInPublishersTable(publisher);
            stmt = (PreparedStatement) connection.prepareStatement(
                    "SELECT publisher_id  FROM publishers WHERE publisher=?;");
            stmt.setString(1, publisher);
            rs = stmt.executeQuery();
            if (rs.first()) {
                id_publisher = rs.getInt("publisher_id");
            }
        }
        stmt = (PreparedStatement) connection.prepareStatement(
                "INSERT INTO papers VALUES (NULL,?,?,'citeseer',?,?,?);");
        stmt.setString(1, title);
        stmt.setString(2, URL);
        if (publisher != null) {
            stmt.setString(3, String.valueOf(id_publisher));
        } else {
            stmt.setString(3, null);
        }
        stmt.setString(5, String.valueOf(yearPublication));
        stmt.setString(4, abstractText);
        stmt.executeUpdate();
    }

    public boolean isArticleInDatabase(String URL) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT *  from papers where url =?;");
        stmt.setString(1, URL);
        ResultSet rs = stmt.executeQuery();

        return rs.first();
    }

    public synchronized void insertInTableCitations(String title, String citation_title) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement("SELECT paper_id  from papers where paper=?");
        stmt.setString(1, title);
        ResultSet rs = stmt.executeQuery();
        int id_citator;
        if (rs.first()) {
            id_citator = rs.getInt("paper_id");
        } else {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement("SELECT paper_id  from papers where paper=?");
        stmt.setString(1, citation_title);
        rs = stmt.executeQuery();
        int id_citatee;
        if (rs.first()) {
            id_citatee = rs.getInt("paper_id");
        } else {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT citation_id  FROM citations WHERE citator_id =? && citatee_id = ?");
        stmt.setString(1, String.valueOf(id_citator));
        stmt.setString(2, String.valueOf(id_citatee));
        rs = stmt.executeQuery();
        if (rs.first()) {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement("INSERT INTO citations VALUES ( NULL, ?, ?)");
        stmt.setString(1, String.valueOf(id_citator));
        stmt.setString(2, String.valueOf(id_citatee));
        stmt.executeUpdate();
    }

    public void insertInTableAuthorsPublication(String author, String title) throws SQLException {
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement("SELECT paper_id  from papers where paper =?;");
        stmt.setString(1, title);
        ResultSet rs = stmt.executeQuery();
        int id_title;
        if (rs.first()) {
            id_title = rs.getInt("paper_id");
        } else {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT author_id  FROM authors WHERE author=?;");
        stmt.setString(1, author);
        rs = stmt.executeQuery();
        int id_author;
        if (rs.first()) {
            id_author = rs.getInt("author_id");
        } else {
            return;
        }
        stmt = (PreparedStatement) connection.prepareStatement(
                "SELECT author_paper_id  FROM author_paper WHERE author_id=? && paper_id=?;");
        stmt.setString(1, String.valueOf(id_author));
        stmt.setString(2, String.valueOf(id_title));
        rs = stmt.executeQuery();
        if (rs.first()) {
            return;
        }

        stmt = (PreparedStatement) connection.prepareStatement("INSERT INTO author_paper   "
                + "VALUES ( NULL, ?, ?);");
        stmt.setString(1, String.valueOf(id_author));
        stmt.setString(2, String.valueOf(id_title));
        stmt.executeUpdate();
    }

    public ArrayList<Integer> getIdPapers(String substring) throws SQLException {
        String[] temp = substring.split(" ");

        String request = "SELECT paper_id FROM papers WHERE ";
        for (int i = 0; i < temp.length - 1; ++i) {
            request += ("paper LIKE \"%" + temp[i] + "%\" and ");
        }
        request += ("paper LIKE \"%" + temp[temp.length - 1] + "%\";");
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet rs = stmt.executeQuery();
        ArrayList<Integer> result = new ArrayList<>();

        while (rs.next()) {
            result.add(rs.getInt("paper_id"));
        }
        return result;

    }

    public ArrayList<Integer> getIdAuthors(int paper_id) throws SQLException {
        PreparedStatement stmt =
                (PreparedStatement) connection.prepareStatement("SELECT author_id FROM author_paper where paper_id = " + paper_id + ";");
        ResultSet rs = stmt.executeQuery();
        ArrayList<Integer> result = new ArrayList<>();

        while (rs.next()) {
            result.add(rs.getInt("author_id"));
        }
        return result;
    }

    public ArrayList<Author> getAuthorsByPaperId(int paper_id) throws SQLException {
        PreparedStatement stmt =
                (PreparedStatement) connection.prepareStatement("SELECT author_id FROM author_paper where paper_id = " + paper_id + ";");
        ResultSet rs = stmt.executeQuery();
        ArrayList<Author> result = new ArrayList<>();
        if (rs.first()) {
            do {
                int id = rs.getInt("author_id");
                PreparedStatement stmt2 =
                        (PreparedStatement) connection.prepareStatement("SELECT * FROM authors where author_id = " + id + ";");
                ResultSet rs2 = stmt2.executeQuery();
                if (rs2.first()) {
                    String name = rs2.getString("author");
                    String url = rs2.getString("url");
                    String site = rs2.getString("cite");
                    result.add(new Author(id, name, site, url));
                }
            } while (rs.next());
        }
        return result;
    }

    public String getNameByAuthorId(int authorId) throws SQLException {
        PreparedStatement stmt = (PreparedStatement)
                connection.prepareStatement("SELECT author FROM authors where author_id = " + authorId + ";");
        ResultSet rs = stmt.executeQuery();
        String result = "";
        if (rs.first()) {
            result = rs.getString("author");
        }
        return result;
    }

    public ArrayList<Integer> getIdCitatedAuthors(int paper_id) throws Exception {
        PreparedStatement stmt = (PreparedStatement)
                connection.prepareStatement("SELECT citatee_id FROM citations where citator_id = " + paper_id + ";");
        ResultSet rs = stmt.executeQuery();
        ArrayList<Integer> citationPapers = new ArrayList<>();
        ArrayList<Integer> result = new ArrayList<>();
        while (rs.next()) {
            citationPapers.add(rs.getInt("citatee_id"));
        }
        for (Integer paper : citationPapers) {
            result.addAll(getIdAuthors(paper));
        }
        return result;
    }

    public ArrayList<Author> getAuthorsCitated(int paper_id) throws SQLException {
        PreparedStatement stmt = (PreparedStatement)
                connection.prepareStatement("SELECT citatee_id FROM citations where citator_id = " + paper_id + ";");
        ResultSet rs = stmt.executeQuery();
        ArrayList<Integer> citationPapers = new ArrayList<>();
        ArrayList<Author> result = new ArrayList<>();
        while (rs.next()) {
            citationPapers.add(rs.getInt("citatee_id"));
        }
        for (Integer paper : citationPapers) {
            result.addAll(getAuthorsByPaperId(paper));
        }
        return result;
    }

    // Похоже этот метод может работать неверно, рассматривая несколько авторов под одним именем
    public ArrayList<Integer> getIdOfPapersByAuthor(String author) throws SQLException {
        ArrayList<Integer> res = new ArrayList<>();
        String[] temp = author.split(" ");
        String request = "SELECT author_id FROM authors WHERE ";
        for (int i = 0; i < temp.length - 1; ++i) {
            request += ("author LIKE \"%" + temp[i] + " %\" and ");
        }
        request += ("author LIKE \"%" + temp[temp.length - 1] + " %\";");
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet rs = stmt.executeQuery();
        ArrayList<Integer> authors_id = new ArrayList<>();

        while (rs.next()) {
            authors_id.add(rs.getInt("author_id"));
        }
        for (Integer anAuthors_id : authors_id) {
            request = "SELECT paper_id FROM author_paper WHERE author_id = " + anAuthors_id + ";";

            stmt = (PreparedStatement) connection.prepareStatement(request);
            rs = stmt.executeQuery();
            while (rs.next()) {
                res.add(rs.getInt("paper_id"));
            }
        }
        return res;
    }

    // Get first author by name
    public Integer getAuthorIdByName(String authorName) throws SQLException {
        String[] words = authorName.split(" ");

        StringBuilder request = new StringBuilder("select author_id from authors where ");
        for (int i = 0; i < words.length; i++) {
            if (i > 0) {
                request.append(" and ");
            }
            request.append("author like \"%")
                    .append(words[i])
                    .append(" %\"");
        }
        request.append(";");

        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request.toString());
        ResultSet rs = stmt.executeQuery();

        if (rs.next()) {
            return rs.getInt("author_id");
        }
        return null;
    }

    public ArrayList<Author> getAllAuthors() throws SQLException {
        ArrayList<Author> authors = new ArrayList<>();

        String request = "select * from authors;";
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet result = stmt.executeQuery();

        while (result.next()) {
            int authorID = result.getInt("author_id");
            String authorName = result.getString("author");
            String url = result.getString("url");
            String cite = result.getString("cite");

            authors.add(new Author(authorID, authorName, url, cite));
        }

        return authors;
    }

    public Collection<Integer> getPapersIDByAuthorID(int authorID) throws SQLException {
        Collection<Integer> papersID = new ArrayList<>();

        String request = "select paper_id from author_paper where author_id = " + authorID + ";";
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet result = stmt.executeQuery();

        while (result.next()) {
            papersID.add(result.getInt(PAPER_ID));
        }

        return papersID;
    }

    public Collection<Paper> getPapersFromAuthorsID(int authorID) throws SQLException {
        Collection<Paper> papers = new ArrayList<>();

        for (Integer paperID : getPapersIDByAuthorID(authorID)) {
            papers.add(new Paper(paperID, getAuthorsByPaperId(paperID), getAuthorsCitated(paperID)));
        }

        return papers;
    }

    public Collection<Integer> getAllPapersID() throws SQLException {
        Collection<Integer> papers = new ArrayList<>();

        String request = "select paper_id from papers;";
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet result = stmt.executeQuery();

        while (result.next()) {
            int paperID = result.getInt(PAPER_ID);
            papers.add(paperID);
        }

        return papers;
    }

    public PaperDescription getPaperDescription(int paperID) throws SQLException {
        String request = "select * from papers where " + PAPER_ID + " = " + paperID + ";";
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet result = stmt.executeQuery();

        String title = result.getString(PAPER_TITLE);
        String url = result.getString(PAPER_URL);
        String cite = result.getString(PAPER_CITE);
        String abstr = result.getString(PAPER_ABSTRACT);
        String year = result.getString(PAPER_YEAR_PUBLICATION);

        return new PaperDescription(paperID, title, url, cite, abstr, year);
    }

    public ArrayList<PaperDescription> getAllPaperDescriptions() throws SQLException {
        String request = "select * from papers;";
        PreparedStatement stmt = (PreparedStatement) connection.prepareStatement(request);
        ResultSet result = stmt.executeQuery();

        ArrayList<PaperDescription> papers = new ArrayList<>();
        while (result.next()) {
            int paperID = result.getInt(PAPER_ID);
            String title = result.getString(PAPER_TITLE);
            String url = result.getString(PAPER_URL);
            String cite = result.getString(PAPER_CITE);
            String abstr = result.getString(PAPER_ABSTRACT);
            String year = result.getString(PAPER_YEAR_PUBLICATION);
            papers.add(new PaperDescription(paperID, title, url, cite, abstr, year));
        }

        return papers;
    }
}
